<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\SimpleExcel\SimpleExcelReader;
use App\Models\Analysis;
use App\Models\AnalysisItem;
use App\Helpers\Efris;

class AnalysisController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $records = Analysis::all();
        return view('analysis.index',compact('records'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $customers = \App\Models\Customer::all();
        return view('analysis.create',compact('customers'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        try{
            \DB::beginTransaction();
            $analysis = new Analysis;
            $analysis->status = "Ongoing";
            $analysis->name = $request->name;
            $analysis->successful = 0;
            $analysis->failed = 0;
            $analysis->total = 0;
            $analysis->customer_id = $request->customer;
            $analysis->save();

            if ($request->hasFile('purchases')) {

                $rows = SimpleExcelReader::create($request->purchases, 'csv')
                    // ->noHeaderRow()
                ->getRows()
                ->each(function(array $row) use ($analysis) {
                    $fdn = $row['FDN'];

                    if ($fdn) {
                        $entry = new AnalysisItem;
                        $entry->fdn = $fdn;
                        $entry->analysis_id = $analysis->id;
                        $entry->type = "Purchase";
                        $entry->status = "Pending";
                        $entry->standard_sales = 0;
                        $entry->exempted_sales = 0;
                        $entry->zero_rated_sales = 0;
                        $entry->deemed_sales = 0;
                        $entry->vat = 0;
                        $entry->save();

                        $analysis->total += 1;
                        $analysis->save();
                    }

                });
            }
            if ($request->hasFile('sales')) {

                $rows = SimpleExcelReader::create($request->sales, 'csv')
                    // ->noHeaderRow()
                ->getRows()
                ->each(function(array $row) use ($analysis) {
                    $fdn = $row['FDN'];

                    if ($fdn) {
                        $entry = new AnalysisItem;
                        $entry->fdn = $fdn;
                        $entry->analysis_id = $analysis->id;
                        $entry->type = "Sale";
                        $entry->status = "Pending";
                        $entry->standard_sales = 0;
                        $entry->exempted_sales = 0;
                        $entry->zero_rated_sales = 0;
                        $entry->deemed_sales = 0;
                        $entry->vat = 0;
                        $entry->save();

                        $analysis->total += 1;
                        $analysis->save();
                    }
                });
            }
            \DB::commit();

            return redirect()->back()->with('success','Analysis of records as started');
        }catch(\Throwable $ex){
            return redirect()->back()->withErrors(['error'=>$ex->getMessage()])->withInput();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $analysis = Analysis::find($id);

        $sales = new \stdClass;
        $sales->standard_sales = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Sale')->sum('standard_sales'),2);
        $sales->zero_rated_sales = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Sale')->sum('zero_rated_sales'),2);
        $sales->deemed_sales = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Sale')->sum('deemed_sales'),2);
        $sales->exempted_sales = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Sale')->sum('exempted_sales'),2);
        $sales->vat = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Sale')->sum('vat'),2);
        $sales->total_count = AnalysisItem::where('analysis_id',$id)->where('type','Sale')->count();
        $sales->failed = AnalysisItem::where('analysis_id',$id)->where('type','Sale')->where('status','Failed')->get();


        $purchases = new \stdClass;
        $purchases->standard_sales = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Purchase')->sum('standard_sales'),2);
        $purchases->zero_rated_sales = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Purchase')->sum('zero_rated_sales'),2);
        $purchases->deemed_sales = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Purchase')->sum('deemed_sales'),2);
        $purchases->exempted_sales = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Purchase')->sum('exempted_sales'),2);
        $purchases->vat = number_format(AnalysisItem::where('analysis_id',$id)->where('type','Purchase')->sum('vat'),2);
        $purchases->total_count = AnalysisItem::where('analysis_id',$id)->where('type','Purchase')->count();
        $purchases->failed = AnalysisItem::where('analysis_id',$id)->where('type','Purchase')->where('status','Failed')->get();

        $analysis->sales = $sales;
        $analysis->purchases = $purchases;

        return view('analysis.details',compact('analysis'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $response = $this->analysis($id);

        return redirect()->back()->with(($response->code == "00") ? 'success': 'error',$response->message )->withInput();
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function analysis($fdn = "")
    {

        $response = new \stdClass;
        $response->code = "01";
        $response->message = "Unknown error";
        
        if ($fdn != "") {
            $record = AnalysisItem::where('fdn',$fdn)->first();
        }else{
            $user = \App\Models\User::first();
            \Auth::login($user);

            $record = AnalysisItem::where('status','Pending')->inRandomOrder()->first();
        }

        if ($record) {
            $record->status = "Ongoing";
            $record->save();

            $efris = new Efris;
            $efris = $efris->invoiceDetails($record->fdn);

            $analysis = $record->analysis;

            if ($efris->code == "00") {
                $data = json_decode($efris->data);

                if ($data) {
                    foreach ($data->taxDetails as $details) {
                        if ($details->taxCategoryCode == "01") {
                            $record->standard_sales += $details->netAmount;
                            $record->vat += $details->grossAmount - $details->netAmount;

                        // $summary->vat += $details->grossAmount - $details->netAmount;
                        }elseif ($details->taxCategoryCode == "02") {
                            $record->zero_rated_sales += $details->netAmount;
                        // $summary->zero_rated += $details->netAmount;
                        }elseif ($details->taxCategoryCode == "03") {
                            $record->exempted_sales += $details->netAmount;
                        // $summary->exempted += $details->netAmount;
                        }elseif ($details->taxCategoryCode == "04") {
                            $record->deemed_sales += $details->netAmount;
                        // $summary->deemed += $details->netAmount;
                        }
                    }

                    $analysis->successful += 1;
                    $record->status = "Successful";

                    $response->code ="00";
                    $response->message = "Successful";

                }else{
                    $analysis->failed += 1;
                    $record->status = "Failed";

                    $response->code ="01";
                    $response->message = "Unknown error";
                }

            }else{
                $analysis->failed += 1;
                $record->status = "Failed";

                $response->code ="01";
                $response->message = $efris->message;
            }

            $record->save();

            $analysis->save();
        }

        if ($fdn != "") {
            return $response;
        }else{ 
            $count = AnalysisItem::where('status','Pending')->count();
            if ($count > 0) {
               $this->analysis();
            }
        }
    }
}
