<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\ExpenseItem;

class ExpenseItemController extends Controller {

    public function __construct() {
		// $this->authorizeResource(ExpenseItem::class, 'expenseItem');
	}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $expenseItems = ExpenseItem::query();

		if (!!$request->trashed) {
			$expenseItems->withTrashed();
		}

        if(!empty($request->search)) {
			$expenseItems->where('name', 'like', '%' . $request->search . '%');
		}

        $expenseItems = $expenseItems->paginate(10);

        return view('expense_items.index', compact('expenseItems'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('expense_items.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required"]);

        try {

            $expenseItem = new ExpenseItem();
            $expenseItem->name = $request->name;
            $expenseItem->save();

            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('expense_items.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\ExpenseItem $expenseItem
     *
     * @return \Illuminate\Http\Response
     */
    public function show(ExpenseItem $expenseItem,) {

        return view('expense_items.show', compact('expenseItem'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\ExpenseItem $expenseItem
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(ExpenseItem $expenseItem,) {

        return view('expense_items.edit', compact('expenseItem'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ExpenseItem $expenseItem,) {

        $request->validate(["name" => "required"]);

        try {
            $expenseItem->name = $request->name;
            $expenseItem->save();

            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('expense_items.edit', compact('expenseItem'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\ExpenseItem $expenseItem
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(ExpenseItem $expenseItem,) {

        try {
            $expenseItem->delete();

            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('expense_items.index', [])->with('error', 'Cannot delete Expense Item: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\ExpenseItem $expenseItem
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $expenseItem_id,) {

        $expenseItem = ExpenseItem::withTrashed()->find($expenseItem_id);
        $this->authorize('delete', [ExpenseItem::class, $expenseItem]);

        if (!empty($expenseItem)) {
            $expenseItem->restore();
            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item restored successfully'));
        } else {
            return redirect()->route('expense_items.index', [])->with('error', 'Expense Item not found');
        }
    }

    public function purge( int $expenseItem_id,) {

        $expenseItem = ExpenseItem::withTrashed()->find($expenseItem_id);
        $this->authorize('delete', [ExpenseItem::class, $expenseItem]);

        if (!empty($expenseItem)) {
            $expenseItem->forceDelete();
            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item purged successfully'));
        } else {
            return redirect()->route('expense_items.index', [])->with('error', __('Expense Item not found'));
        }
    }
    //@endsoftdelete
}
