<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Item;

class ItemController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Item::class, 'item');
	}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $items = Item::query();

		if (!!$request->trashed) {
			$items->withTrashed();
		}

        if(!empty($request->search)) {
			$items->where('sku', 'like', '%' . $request->search . '%');
		}

        $items = $items->paginate(10);

        return view('items.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('items.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required", "type" => "required", "cost_price" => "required", "selling_price" => "required", "stock" => "required"]);

        try {

            $item = new Item();
            $item->sku = $request->sku;
		$item->name = $request->name;
		$item->type = $request->type;
		$item->cost_price = $request->cost_price;
		$item->selling_price = $request->selling_price;
		$item->stock = $request->stock;
            $item->save();

            return redirect()->route('items.index', [])->with('success', __('Item created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('items.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Item $item
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Item $item,) {

        return view('items.show', compact('item'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Item $item
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Item $item,) {

        return view('items.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Item $item,) {

        $request->validate(["name" => "required", "type" => "required", "cost_price" => "required", "selling_price" => "required", "stock" => "required"]);

        try {
            $item->sku = $request->sku;
		$item->name = $request->name;
		$item->type = $request->type;
		$item->cost_price = $request->cost_price;
		$item->selling_price = $request->selling_price;
		$item->stock = $request->stock;
            $item->save();

            return redirect()->route('items.index', [])->with('success', __('Item edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('items.edit', compact('item'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Item $item
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Item $item,) {

        try {
            $item->delete();

            return redirect()->route('items.index', [])->with('success', __('Item deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('items.index', [])->with('error', 'Cannot delete Item: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Item $item
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $item_id,) {

        $item = Item::withTrashed()->find($item_id);
        $this->authorize('delete', [Item::class, $item]);

        if (!empty($item)) {
            $item->restore();
            return redirect()->route('items.index', [])->with('success', __('Item restored successfully'));
        } else {
            return redirect()->route('items.index', [])->with('error', 'Item not found');
        }
    }

    public function purge( int $item_id,) {

        $item = Item::withTrashed()->find($item_id);
        $this->authorize('delete', [Item::class, $item]);

        if (!empty($item)) {
            $item->forceDelete();
            return redirect()->route('items.index', [])->with('success', __('Item purged successfully'));
        } else {
            return redirect()->route('items.index', [])->with('error', __('Item not found'));
        }
    }
    
    public function item_details($id)
    {
        $item = Item::find($id);

        return $item;
    }
}
