<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\PaymentMethod;

class PaymentMethodController extends Controller {

    public function __construct() {
		// $this->authorizeResource(PaymentMethod::class, 'paymentMethod');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $paymentMethods = PaymentMethod::query();

        if (!!$request->trashed) {
         $paymentMethods->withTrashed();
     }

     if(!empty($request->search)) {
         $paymentMethods->where('name', 'like', '%' . $request->search . '%');
     }

     $paymentMethods = $paymentMethods->paginate(10);

     return view('payment_methods.index', compact('paymentMethods'));
 }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('payment_methods.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required", "type" => "required"]);

        try {

            $paymentMethod = new PaymentMethod();
            $paymentMethod->name = $request->name;
            $paymentMethod->type = $request->type;
            $paymentMethod->save();

            return redirect()->route('payment_methods.index', [])->with('success', __('Payment Method created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('payment_methods.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\PaymentMethod $paymentMethod
     *
     * @return \Illuminate\Http\Response
     */
    public function show(PaymentMethod $paymentMethod,) {

        return view('payment_methods.show', compact('paymentMethod'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\PaymentMethod $paymentMethod
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(PaymentMethod $paymentMethod,) {

        return view('payment_methods.edit', compact('paymentMethod'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PaymentMethod $paymentMethod,) {

        $request->validate(["name" => "required", "type" => "required"]);

        try {
            $paymentMethod->name = $request->name;
            $paymentMethod->type = $request->type;
            $paymentMethod->save();

            return redirect()->route('payment_methods.index', [])->with('success', __('Payment Method edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('payment_methods.edit', compact('paymentMethod'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\PaymentMethod $paymentMethod
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(PaymentMethod $paymentMethod,) {

        try {
            $paymentMethod->delete();

            return redirect()->route('payment_methods.index', [])->with('success', __('Payment Method deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('payment_methods.index', [])->with('error', 'Cannot delete Payment Method: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\PaymentMethod $paymentMethod
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $paymentMethod_id,) {

        $paymentMethod = PaymentMethod::withTrashed()->find($paymentMethod_id);
        $this->authorize('delete', [PaymentMethod::class, $paymentMethod]);

        if (!empty($paymentMethod)) {
            $paymentMethod->restore();
            return redirect()->route('payment_methods.index', [])->with('success', __('Payment Method restored successfully'));
        } else {
            return redirect()->route('payment_methods.index', [])->with('error', 'Payment Method not found');
        }
    }

    public function purge( int $paymentMethod_id,) {

        $paymentMethod = PaymentMethod::withTrashed()->find($paymentMethod_id);
        $this->authorize('delete', [PaymentMethod::class, $paymentMethod]);

        if (!empty($paymentMethod)) {
            $paymentMethod->forceDelete();
            return redirect()->route('payment_methods.index', [])->with('success', __('Payment Method purged successfully'));
        } else {
            return redirect()->route('payment_methods.index', [])->with('error', __('Payment Method not found'));
        }
    }
    //@endsoftdelete
}
