<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Purchase;

class PurchaseController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Purchase::class, 'purchase');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $purchases = Purchase::query();

        if (!!$request->trashed) {
         $purchases->withTrashed();
     }

     $purchases->with('supplier');
     $purchases->with('item');
     $purchases->with('payment_method');

     if(!empty($request->search)) {
         $purchases->where('amount', 'like', '%' . $request->search . '%');
     }

     $purchases = $purchases->get();

     return view('purchases.index', compact('purchases'));
 }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        $suppliers = \App\Models\Supplier::all();
        $items = \App\Models\Item::all();
        $paymentMethods = \App\Models\PaymentMethod::all();

        return view('purchases.create', compact('suppliers', 'items', 'paymentMethods'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["supplier_id" => "required", "items_id" => "required", "payment_method_id" => "required", "amount" => "required"]);

        try {

            $request->amount = str_replace(',', '', $request->amount);
            \DB::beginTransaction();
            $purchase = new Purchase();
            $purchase->supplier_id = $request->supplier_id;
            $purchase->item_id = $request->items_id;
            $purchase->payment_method_id = $request->payment_method_id;
            $purchase->amount = $request->amount;
            $purchase->user_id = \Auth::user()->id;
            $purchase->save();

            if ($purchase->payment_method->type == "Credit") {
                $purchase->balance = $purchase->amount;
                $purchase->save();

                $supplier = $purchase->supplier;
                $supplier->balance += $purchase->amount;
                $supplier->save();
            }else{
                $purchase->balance = 0;
                $purchase->save();
            }

            \DB::commit();

            return redirect()->route('purchases.index', [])->with('success', __('Purchase created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('purchases.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Purchase $purchase
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Purchase $purchase,) {

        return view('purchases.show', compact('purchase'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Purchase $purchase
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Purchase $purchase,) {

        $suppliers = \App\Models\Supplier::all();
        $items = \App\Models\Item::all();
        $paymentMethods = \App\Models\PaymentMethod::all();

        return view('purchases.edit', compact('purchase', 'suppliers', 'items', 'payment_methods'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Purchase $purchase,) {

        $request->validate(["supplier_id" => "required", "items_id" => "required", "payment_method_id" => "required", "amount" => "required", "balance" => "required"]);

        try {
            $purchase->supplier_id = $request->supplier_id;
            $purchase->items_id = $request->items_id;
            $purchase->payment_method_id = $request->payment_method_id;
            $purchase->amount = $request->amount;
            $purchase->balance = $request->balance;
            $purchase->user_id = \Auth::user()->id;
            $purchase->save();

            return redirect()->route('purchases.index', [])->with('success', __('Purchase edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('purchases.edit', compact('purchase'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Purchase $purchase
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Purchase $purchase,) {

        try {
            $purchase->delete();

            return redirect()->route('purchases.index', [])->with('success', __('Purchase deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('purchases.index', [])->with('error', 'Cannot delete Purchase: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Purchase $purchase
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $purchase_id,) {

        $purchase = Purchase::withTrashed()->find($purchase_id);
        $this->authorize('delete', [Purchase::class, $purchase]);

        if (!empty($purchase)) {
            $purchase->restore();
            return redirect()->route('purchases.index', [])->with('success', __('Purchase restored successfully'));
        } else {
            return redirect()->route('purchases.index', [])->with('error', 'Purchase not found');
        }
    }

    public function purge( int $purchase_id,) {

        $purchase = Purchase::withTrashed()->find($purchase_id);
        $this->authorize('delete', [Purchase::class, $purchase]);

        if (!empty($purchase)) {
            $purchase->forceDelete();
            return redirect()->route('purchases.index', [])->with('success', __('Purchase purged successfully'));
        } else {
            return redirect()->route('purchases.index', [])->with('error', __('Purchase not found'));
        }
    }
    //@endsoftdelete
}
