<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Invoice;
use Dompdf\Dompdf;
use Illuminate\Support\Facades\View;
use Dompdf\Options;
use App\Models\InvoicePayment;
use App\Models\Purchase;
use App\Models\Expense;
use App\Models\Item;
use App\Models\LedgerEntries;
use Auth;
use App\Models\Customer;

class ReportsController extends Controller
{
    public function invoices(Request $request)
    {
        $invoices = [];
        $users = User::all();

        if ($request->start_date) {
            $invoices = Invoice::query();

            if (Auth::user()->account_type == "User") {
                $invoices->where('created_by',Auth::user()->id);
            }

            $invoices->whereBetween('created_at',[$request->start_date,date('Y-m-d',strtotime($request->end_date.' +1days'))]);

            if ($request->user) {
                $invoices->whereIn('created_by',$request->user);
            }

            $invoices = $invoices->get();

            if ($request->download) {
                $options = new Options();
                $options->set('defaultFont', 'Courier');
                $options->set('isRemoteEnabled', true);

                $dompdf = new Dompdf($options);
                $view = View::make('reports.pdfs.invoices',compact('invoices','request'))->render();
                $dompdf->loadHtml($view);
                
                $dompdf->setPaper('A4', 'landscape');

                // Render the HTML as PDF
                $dompdf->render();
                $dompdf->stream('Sales_Report_'.date('d_M_y',strtotime($request->start_date)).'_to_'.date('d_M_y',strtotime($request->end_date)).'.pdf');
                // return view('reports.pdfs.invoices',compact('invoices','request'));
            }
        }

        return view('reports.invoices',compact('invoices','users','request'));
    }

    public function pl(Request $request)
    {
        $summary = new \stdClass;
        $summary->search = false;

        if ($request->start_date) {
            $start_date = $request->start_date;
            $end_date = date('Y-m-d',strtotime($request->end_date.' +1days'));

            if (Auth::user()->account_type == "User") {
                $sales  = InvoicePayment::where('user_id',Auth::user()->id)->whereBetween('created_at',[$start_date,$end_date])->sum('amount');
                $purchases = Purchase::where('user_id',Auth::user()->id)->whereBetween('created_at',[$start_date,$end_date])->sum('amount');
                $expenses = Expense::where('user_id',Auth::user()->id)->whereBetween('created_at',[$start_date,$end_date])->sum('amount');
            }else{
                $sales  = InvoicePayment::whereBetween('created_at',[$start_date,$end_date])->sum('amount');
                $purchases = Purchase::whereBetween('created_at',[$start_date,$end_date])->sum('amount');
                $expenses = Expense::whereBetween('created_at',[$start_date,$end_date])->sum('amount');
            }

            $summary->sales = $sales;
            $summary->expenses = $expenses;
            $summary->purchases = $purchases;
            $summary->search = true;

            if ($request->download) {
                $options = new Options();
                $options->set('defaultFont', 'Courier');
                $options->set('isRemoteEnabled', true);

                $dompdf = new Dompdf($options);
                $view = View::make('reports.pdfs.pl',compact('summary','request'))->render();
                $dompdf->loadHtml($view);
                

                // Render the HTML as PDF
                $dompdf->render();
                $dompdf->stream('Profit_loss_'.date('d_M_y',strtotime($request->start_date)).'_to_'.date('d_M_y',strtotime($request->end_date)).'.pdf');
                // return view('reports.pdfs.invoices',compact('invoices','request'));
            }
        }

        return view('reports.pl',compact('summary','request'));
    }

    public function incomes(Request $request)
    {
        $payments = [];
        $users = User::all();

        if ($request->start_date) {
            $payments = InvoicePayment::query();

            if (Auth::user()->account_type == "User") {
                $payments->where('user_id',Auth::user()->id);
            }

            $payments->whereBetween('created_at',[$request->start_date,date('Y-m-d',strtotime($request->end_date.' +1days'))]);

            if ($request->user) {
                $payments->whereIn('user_id',$request->user);
            }

            $payments = $payments->get();

            if ($request->download) {
                $options = new Options();
                $options->set('defaultFont', 'Courier');
                $options->set('isRemoteEnabled', true);

                $dompdf = new Dompdf($options);
                $view = View::make('reports.pdfs.incomes',compact('payments','request'))->render();
                $dompdf->loadHtml($view);
                
                $dompdf->setPaper('A4', 'landscape');

                // Render the HTML as PDF
                $dompdf->render();
                $dompdf->stream('Incomes_Report_'.date('d_M_y',strtotime($request->start_date)).'_to_'.date('d_M_y',strtotime($request->end_date)).'.pdf');
                // return view('reports.pdfs.invoices',compact('invoices','request'));
            }
        }

        return view('reports.incomes',compact('payments','users','request'));
    }

    public function expenses(Request $request)
    {
        $expenses = [];
        $users = User::all();

        if ($request->start_date) {
            $expenses = Expense::query();

            if (Auth::user()->account_type == "User") {
                $expenses->where('user_id',Auth::user()->id);
            }

            $expenses->whereBetween('created_at',[$request->start_date,date('Y-m-d',strtotime($request->end_date.' +1days'))]);

            if ($request->user) {
                $expenses->whereIn('user_id',$request->user);
            }

            $expenses = $expenses->get();

            if ($request->download) {
                $options = new Options();
                $options->set('defaultFont', 'Courier');
                $options->set('isRemoteEnabled', true);

                $dompdf = new Dompdf($options);
                $view = View::make('reports.pdfs.expenses',compact('expenses','request'))->render();
                $dompdf->loadHtml($view);
                
                $dompdf->setPaper('A4', 'landscape');

                // Render the HTML as PDF
                $dompdf->render();
                $dompdf->stream('Expenses_Report_'.date('d_M_y',strtotime($request->start_date)).'_to_'.date('d_M_y',strtotime($request->end_date)).'.pdf');
                // return view('reports.pdfs.invoices',compact('invoices','request'));
            }
        }

        return view('reports.expenses',compact('expenses','users','request'));
    }

    public function purchases(Request $request)
    {
        $purchases = [];
        $users = Item::all();

        if ($request->start_date) {
            $purchases = Purchase::query();

            if (Auth::user()->account_type == "User") {
                $purchases->where('user_id',Auth::user()->id);
            }

            $purchases->whereBetween('created_at',[$request->start_date,date('Y-m-d',strtotime($request->end_date.' +1days'))]);

            if ($request->user) {
                $purchases->whereIn('item_id',$request->user);
            }

            $purchases = $purchases->get();

            if ($request->download) {
                $options = new Options();
                $options->set('defaultFont', 'Courier');
                $options->set('isRemoteEnabled', true);

                $dompdf = new Dompdf($options);
                $view = View::make('reports.pdfs.purchases',compact('purchases','request'))->render();
                $dompdf->loadHtml($view);
                
                $dompdf->setPaper('A4', 'landscape');

                // Render the HTML as PDF
                $dompdf->render();
                $dompdf->stream('Purchases_Report_'.date('d_M_y',strtotime($request->start_date)).'_to_'.date('d_M_y',strtotime($request->end_date)).'.pdf');
                // return view('reports.pdfs.invoices',compact('invoices','request'));
            }
        }

        return view('reports.purchases',compact('purchases','users','request'));
    }

    public function customers_ledgers(Request $request)
    {
        // $customers = Customer::all();

        // foreach($customers as $customer){
        //     $balance = 0;
        //     $invoices = Invoice::where('id',$customer->id)->where('type','Invoice')->get();
    
        //     $payments = InvoicePayment::where('customer_id',$customer->id)->get();

        //     $combined = $invoices->merge($payments);
        //     $sorted = $combined->sortByDesc('created_at');

        //     foreach($sorted as $item){
        //         $last_entry = LedgerEntries::where('customer_id',$item->customer_id)->orderBy('id','desc')->first();

        //         $balance = 0;

        //         if ($last_entry) {
        //             $balance = $last_entry->balance;
        //         }

        //         if ($item instanceof Invoice) {
        //             $item->type = 'Invoice';
        //             $balance -= $item->gross_amount;
        //         } elseif ($item instanceof InvoicePayment) {
        //             $item->type = 'Payment';
        //             $balance += $item->amount;
        //         }

        //         $debit = ($item->type == "Invoice") ? $item->gross_amount : null;
        //         $credit = ($item->type == "Payment") ? $item->amount : null;

        //         LedgerEntries::create([
        //             'date' => $item->created_at,
        //             'reference' => $item->type.'#'.$item->id,
        //             'customer_id' => $item->customer_id,
        //             'debit' => $debit,
        //             'credit' => $credit,
        //             'balance' => $balance,
        //             'created_at' => $item->created_at,
        //             'updated_at' => $item->created_at,
        //         ]);
        //     }
        // }        

        // return $sorted;

        $customers = Customer::all();
        $entries = [];
        $balance = '';

        // $payments = InvoicePayment::all();
        // $invoices = Invoice::all();

        // $combined = $invoices->map(function ($invoice) {
        //     $invoice['type'] = 'invoice';
        //     return $invoice;
        // })->merge(
        //     $payments->map(function ($payment) {
        //         $payment['type'] = 'payment';
        //         return $payment;
        //     })
        // )->sortBy('created_at');

        // foreach ($combined as $item) {
        //     $last_entry = LedgerEntries::where('customer_id',$item->customer_id)->orderBy('id','asc')->first();

        //     $balance = 0;
        //     if ($last_entry) {
        //         $balance = $last_entry->balance;
        //     }
        //     $debit = ($item->type == "invoice") ? $item->gross_amount : null;
        //     $credit = ($item->type == "payment") ? $item->amount : null;
        //     if ($item->type == 'invoice') {
        //         $balance -= $item->gross_amount;
        //     } else {
        //         $balance += $item->amount;
        //     }
        //     // Create LedgerEntry
        //     LedgerEntries::create([
        //         'date' => $item->created_at,
        //         'reference' => $item->type.'#'.$item->id,
        //         'customer_id' => $item->customer_id,
        //         'debit' => $debit,
        //         'credit' => $credit,
        //         'balance' => $balance,
        //         'created_at' => $item->created_at,
        //         'updated_at' => $item->created_at,
        //     ]);
        // }

        // return $combined;

        if ($request->start_date) {
            $start_date = $request->start_date;
            $end_date = date('Y-m-d',strtotime($request->end_date.' +1days'));

            $balance = 0;

            $entries = LedgerEntries::where('customer_id',$request->customer)->whereBetween('created_at',[$start_date,$end_date])->orderBy('id','desc')->get();
        }
        return view('reports.customer_ledger',compact('entries','balance','customers','request'));
    }
}
