<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Tax;

class TaxController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Tax::class, 'tax');
	}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $taxes = Tax::query();

		if (!!$request->trashed) {
			$taxes->withTrashed();
		}

        if(!empty($request->search)) {
			$taxes->where('name', 'like', '%' . $request->search . '%');
		}

        $taxes = $taxes->paginate(10);

        return view('taxes.index', compact('taxes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('taxes.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required"]);

        try {

            $tax = new Tax();
            $tax->name = $request->name;
            $tax->save();

            return redirect()->route('taxes.index', [])->with('success', __('Tax created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('taxes.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Tax $tax
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Tax $tax,) {

        return view('taxes.show', compact('tax'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Tax $tax
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Tax $tax,) {

        return view('taxes.edit', compact('tax'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Tax $tax,) {

        $request->validate(["name" => "required"]);

        try {
            $tax->name = $request->name;
            $tax->save();

            return redirect()->route('taxes.index', [])->with('success', __('Tax edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('taxes.edit', compact('tax'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Tax $tax
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Tax $tax,) {

        try {
            $tax->delete();

            return redirect()->route('taxes.index', [])->with('success', __('Tax deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('taxes.index', [])->with('error', 'Cannot delete Tax: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Tax $tax
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $tax_id,) {

        $tax = Tax::withTrashed()->find($tax_id);
        $this->authorize('delete', [Tax::class, $tax]);

        if (!empty($tax)) {
            $tax->restore();
            return redirect()->route('taxes.index', [])->with('success', __('Tax restored successfully'));
        } else {
            return redirect()->route('taxes.index', [])->with('error', 'Tax not found');
        }
    }

    public function purge( int $tax_id,) {

        $tax = Tax::withTrashed()->find($tax_id);
        $this->authorize('delete', [Tax::class, $tax]);

        if (!empty($tax)) {
            $tax->forceDelete();
            return redirect()->route('taxes.index', [])->with('success', __('Tax purged successfully'));
        } else {
            return redirect()->route('taxes.index', [])->with('error', __('Tax not found'));
        }
    }
    //@endsoftdelete
}
