<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Item extends Model
{
    use HasFactory,softDeletes;

    /**
     * Item belongs to Purchase.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function purchase()
    {
        // belongsTo(RelatedModel, foreignKey = purchase_id, keyOnRelatedModel = id)
        return $this->belongsTo(Purchase::class);
    }
}
