<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchasePayment extends Model
{
    use HasFactory,softDeletes;

    /**
     * PurchasePayment belongs to Purchase.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function purchase()
    {
        // belongsTo(RelatedModel, foreignKey = purchase_id, keyOnRelatedModel = id)
        return $this->belongsTo(Purchase::class);
    }

    /**
     * PurchasePayment belongs to Payment_method.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function payment_method()
    {
        // belongsTo(RelatedModel, foreignKey = payment_method_id, keyOnRelatedModel = id)
        return $this->belongsTo(PaymentMethod::class);
    }
}
