<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('monthly_fillings', function (Blueprint $table) {
            $table->id();
             $table->integer('customer_id');
            $table->string('month');
            $table->decimal('standard_sales',10,2)->default(0);
            $table->decimal('deemed_sales',10,2)->default(0);
            $table->decimal('zero_rated_sales',10,2)->default(0);
            $table->decimal('exempted_sales',10,2)->default(0);
            $table->decimal('purchases',10,2)->default(0);
            $table->decimal('net_sales',10,2)->default(0);
            $table->decimal('output_vat',10,2)->default(0);
            $table->decimal('gross_sales',10,2)->default(0);
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('monthly_fillings');
    }
};
