<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
             $table->string('invoice_id')->comment('this is a uuid');
            $table->string('type')->comment('Qoutation, Sales order, Invoice, Recurring Invoice,Receipt Sale');
            $table->integer('project_id')->nullable();
            $table->unsignedBigInteger('invoice_no');
            $table->unsignedBigInteger('customer_id');
            $table->date('issue_date');
            $table->string('subject')->nullable();
            $table->string('reference')->nullable();
            $table->date('due_date');
            $table->date('send_date')->nullable();
            $table->text('ref_number')->nullable();
            $table->integer('shipping_display')->default(1);
            $table->integer('discount_apply')->default(0);
            $table->string('next_invoicing_date')->nullable();
            $table->string('paid')->nullable();
            $table->string('balance')->nullable();
            $table->string('net_amount')->nullable();
            $table->string('vat')->nullable();
            $table->string('gross_amount')->nullable();
            $table->string('sales_person')->nullable();
            $table->text('customer_notes')->nullable();
            $table->text('t_c')->nullable();
            $table->integer('payment_method_id')->nullable();
            $table->string('status');
            $table->integer('created_by')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
