@extends('layouts.app')
@section('content')
<div class="row">
	<div class="col-md-6 mx-auto">
		<div class="">
			<form class="card needs-validation" method="POST" action="{{ url('analysis') }}" enctype="multipart/form-data" novalidate>
				@csrf
				<div class="card-header">
					<h5>New Analysis</h5>
				</div>
				<div class="card-body">
					<div class="mb-3">
						<label>Customer</label>
						<select class="select2" name="customer" required>
							<option value="" disabled selected></option>
							@foreach($customers as $customer)
							<option value="{{ $customer->id }}" {{ (@old('customer') == $customer->id) ? 'selected' : '' }}>{{ $customer->name }}</option>
							@endforeach
						</select>
						<div class="invalid-feedback">* Required</div>
					</div>
					<div class="mb-3">
						<label>Name</label>
						<input type="text" name="name" class="form-control" placeholder="Month Of September" value="{{ old('name') }}" required>	
						<div class="invalid-feedback">* Required</div>
					</div>
					<div class="mb-3">
						<label>Purchases</label>
						<input type="file" name="purchases" class="form-control">
					</div>
					<div class="mb-3">
						<label>Sales</label>
						<input type="file" name="sales" class="form-control">
					</div>
				</div>
				<div class="card-footer d-flex justify-content-between">
					<a href="{{ url('analysis') }}" class="btn btn-light">Cancel</a>
					<button class="btn btn-primary" type="submit">Start Analysis</button>
				</div>
			</form>
		</div>
	</div>
</div>
@endsection