@extends('layouts.app')
@section('content')
<div class="row">
	<div class="card col-md-12">
		<div class="card-header">
			<h5>Analysis Details</h5>
		</div>
		<div class="card-body">
			<div class="row">
				<div class="col-md-4 mb-3">
					<label>Customer</label>
					<div>{{ $analysis?->customer?->name }}</div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Name</label>
					<div>{{ $analysis?->name }}</div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Records</label>
					<div>{{ $analysis?->total }}</div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Successful</label>
					<div>{{ number_format($analysis?->successful) }}</div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Failed</label>
					<div>{{ number_format($analysis?->failed) }}</div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Progress</label>
					<div>{{ number_format($analysis?->successful + $analysis->failed) . " / ".$analysis->total}}</div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Input VAT</label>
					<div>{{ $analysis?->purchases?->vat }}</div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Output VAT</label>
					<div>{{ $analysis?->sales?->vat }}</div>
				</div>
				<div class="col-md-4 mb-3">
					<label>Payable VAT</label>
					<div>{{ number_format((str_replace(',', '', $analysis?->sales?->vat) - str_replace(',', '', $analysis->purchases->vat)),2) }}</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-6">
		<div class="card">
			<div class="card-header">
				<h5>Purchases</h5>
			</div>
			<div class="card-body">
				<table class="table table-striped">
					<tbody>
						<tr>
							<th>Standard Purchases</th>
							<td>{{ $analysis->purchases->standard_sales }}</td>
						</tr>
						<tr>
							<th>Deemed Purchases</th>
							<td>{{ $analysis->purchases->deemed_sales }}</td>
						</tr>
						<tr>
							<th>Exempted Purchases</th>
							<td>{{ $analysis->purchases->exempted_sales }}</td>
						</tr>
						<tr>
							<th>Zero Rated Purchases</th>
							<td>{{ $analysis->purchases->zero_rated_sales }}</td>
						</tr>
						<tr>
							<th>Total VAT</th>
							<td>{{ $analysis?->purchases?->vat }}</td>
						</tr>
						<tr>
							<th>Total Records</th>
							<td>{{ $analysis?->purchases->total_count }}</td>
						</tr>
						<tr>
							<th>Failed</th>
							<td>
								@foreach($analysis->purchases->failed as $failed)
									<a href="{{ url('analysis/'.$failed->fdn.'/edit') }}" class="me-4">{{ $failed->fdn }}</a>
								@endforeach
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
	<div class="col-md-6">
		<div class="card">
			<div class="card-header">
				<h5>Sales</h5>
			</div>
			<div class="card-body">
				<table class="table table-striped">
					<tbody>
						<tr>
							<th>Standard Sales</th>
							<td>{{ $analysis->sales->standard_sales }}</td>
						</tr>
						<tr>
							<th>Deemed Sales</th>
							<td>{{ $analysis->sales->deemed_sales }}</td>
						</tr>
						<tr>
							<th>Exempted Sales</th>
							<td>{{ $analysis->sales->exempted_sales }}</td>
						</tr>
						<tr>
							<th>Zero Rated Sales</th>
							<td>{{ $analysis->sales->zero_rated_sales }}</td>
						</tr>
						<tr>
							<th>Total VAT</th>
							<td>{{ $analysis?->sales?->vat }}</td>
						</tr>
						<tr>
							<th>Total Records</th>
							<td>{{ $analysis?->sales->total_count }}</td>
						</tr>
						<tr>
							<th>Failed</th>
							<td>
								@foreach($analysis->sales->failed as $failed)
									<a href="{{ url('analysis/'.$failed->fdn.'/edit') }}" class="me-4">{{ $failed->fdn }}</a>
								@endforeach
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
@endsection