@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-header">
		<h5>Monthly filing</h5>
	</div>
	<div class="card-body">
		<form class="row" method="POST" action="{{ url('load_vat_files') }}" enctype="multipart/form-data">
			@csrf
			<div class="form-group col-md-6 mt-3">
				<label>Purchases Report</label>
				<input type="file" name="purchases" class="form-control">
			</div>
			<div class="form-group col-md-6 mt-3">
				<label>Income Report</label>
				<input type="file" name="sales" class="form-control">
			</div>
			<div class="text-end col-md-12 mt-3">
				<button type="submit" class="btn btn-primary">Load Data</button>
			</div>
		</form>
	</div>
</div>
<div class="card">
	<div class="card-body">
		<div class="response text-end"></div>
		<input type="file" name="file" id="file">
		<button type="button" class="btn btn-primary" id="analyise">Analyse</button>
	</div>
	<div class="card-footer">
		<div class="row">
			<div class="col-md-3 text-center">
				<h5>Standard Sales</h5>
				<span id="standard_sales">0</span>
			</div>
			<div class="col-md-3 text-center">
				<h5>Exempted Sales</h5>
				<span id="exempted_sales">0</span>
			</div>
			<div class="col-md-3 text-center">
				<h5>Deemed Sales</h5>
				<span id="deemed_sales">0</span>
			</div>
			<div class="col-md-3 text-center">
				<h5>Zero Rated Sales</h5>
				<span id="zero_rated_sales">0</span>
			</div>
		</div>
	</div>
</div>
@if(isset($response))
<div class="row">
	@if(isset($response->purchases))
	<div class="col-md-6">
		<div class="card">
			<div class="card-header">
				Purchases
			</div>
			<div class="card-header">
				<div class="table-responsive">
					<table class="table table-striped">
						<thead>
							<th>Item</th>
							<th>Amount</th>
						</thead>
						<tbody>
							<tr>
								<td>Standard Purchases</td>
								<td>{{ number_format($response->purchases->standard,2) }}</td>
							</tr>
							<tr>
								<td>Exempted Purchases</td>
								<td>{{ number_format($response->purchases->exempted,2) }}</td>
							</tr>
							<tr>
								<td>Zero Rated Purchases</td>
								<td>{{ number_format($response->purchases->zero_rated,2) }}</td>
							</tr>
							<tr>
								<td>Deemed Purchases</td>
								<td>{{ number_format($response->purchases->deemed,2) }}</td>
							</tr>
							<tr>
								<td>VAT</td>
								<td>{{ number_format($response->purchases->vat,2) }}</td>
							</tr>
							<tr>
								<th>Successfull Queries</th>
								<th>{{ number_format($response->purchases->succussful) }}</th>
							</tr>
							<tr>
								<td>Failed Queries</td>
								<td>{{ number_format($response->purchases->failed) }}</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	@endif
	@if(isset($response->sales))
	<div class="col-md-6">
		<div class="card">
			<div class="card-header">
				Sales
			</div>
			<div class="card-header">
				<div class="table-responsive">
					<table class="table table-striped">
						<thead>
							<th>Item</th>
							<th>Amount</th>
						</thead>
						<tbody>
							<tr>
								<td>Standard Sales</td>
								<td>{{ number_format($response->sales->standard,2) }}</td>
							</tr>
							<tr>
								<td>Exempted Sales</td>
								<td>{{ number_format($response->sales->exempted,2) }}</td>
							</tr>
							<tr>
								<td>Zero Rated Sales</td>
								<td>{{ number_format($response->sales->zero_rated,2) }}</td>
							</tr>
							<tr>
								<td>Deemed Sales</td>
								<td>{{ number_format($response->sales->deemed,2) }}</td>
							</tr>
							<tr>
								<td>VAT</td>
								<td>{{ number_format($response->sales->vat,2) }}</td>
							</tr>
							<tr>
								<th>Successfull Queries</th>
								<th>{{ number_format($response->sales->succussful) }}</th>
							</tr>
							<tr>
								<td>Failed Queries</td>
								<td>{{ number_format($response->sales->failed) }}</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
	@endif
</div>
@endif
@endsection
@section('customjs')
<script type="text/javascript">
	let standard_sales=0,zero_rated_sales=0,deemed_sales = 0,exempted_sales = 0;
	$(document).ready(function(){

         $('#analyise').click(function(){
               var files = $('#file')[0].files;
               if(files.length > 0){
                     var fd = new FormData();
                     fd.append('file',files[0]);
                     // fd.append('_token',CSRF_TOKEN);
                     $('#responseMsg').hide();
                     $.ajax({
                          url: "{{ url('ajax_upload') }}",
                          method: 'post',
                          data: fd,
                          contentType: false,
                          processData: false,
                          dataType: 'json',
                          beforeSend: function(){
                          	$(".response").html("<i>Uploading .... </i>");
                          },
                          success: function(response){
                                $('#err_file').removeClass('d-block');
                                $('#err_file').addClass('d-none');

                                if(response.success == 1){
                                      // alert(response.message)
                                	analyze(response.uuid,1,response.total)
                                }else if(response.success == 2){ // File not uploaded

                                       alert(response.message)
                                }else{
                                       alert(response.error)
                                } 
                          },
                          error: function(response){
                                console.log("error : " + JSON.stringify(response) );
                          },
                          complete:function(){
                          	// $(".response").html("");
                          }
                     });
               }else{
                     alert("Please select a file.");
               }

         });
    });

    function analyze(uuid,current,total){
    	$.ajax({
    		url: "{{ url('analyze') }}",
    		method: "Post",
    		data: "uuid="+uuid,
    		dataType: 'json',
    		beforeSend: function(){
    			$(".response").html("Analyzing "+current+" of "+total);
    		},
    		success: function(data){
    			if(data.current <= data.count){
    				analyze(data.uuid,data.current,data.count);
    			}
    			
    			standard_sales += data.standard_sales;
    			exempted_sales += data.exempted_sales;
    		},
    		complete: function(){
    			// $(".response").html("");
    		}
    	})

    	$("#standard_sales").text(numberWithCommas(standard_sales));
    	$("#exempted_sales").text(numberWithCommas(exempted_sales));
    }

    function numberWithCommas(x) {
	    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
	}
</script>
@endsection