@extends('items.layout')

@section('items.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
                <ol class="breadcrumb m-0 p-0 flex-grow-1 mb-2 mb-md-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','items']) }}"> Items</a></li>
                </ol>

                <form action="{{ route('items.index', []) }}" method="GET" class="m-0 p-0">
                    <div class="input-group">
                        <input type="text" class="form-control form-control-sm me-2" name="search" placeholder="Search Items..." value="{{ request()->search }}">
                        <span class="input-group-btn">
                            <button class="btn btn-info btn-sm" type="submit"><i class="fa fa-search"></i> @lang('Go!')</button>
                        </span>
                    </div>
                </form>
            </div>
            <div class="card-body">
                <table class="table table-striped table-responsive table-hover">
    <thead role="rowgroup">
    <tr role="row">
                    <th role='columnheader'>Sku</th>
                    <th role='columnheader'>Name</th>
                    <th role='columnheader'>Type</th>
                    <th role='columnheader'>Cost Price</th>
                    <th role='columnheader'>Selling Price</th>
                    <th role='columnheader'>Stock</th>
                <th scope="col" data-label="Actions">Actions</th>
    </tr>
    </thead>
    <tbody>
    @foreach($items as $item)
        <tr>
                            <td data-label="Sku">{{ $item->sku ?: "(blank)" }}</td>
                            <td data-label="Name">{{ $item->name ?: "(blank)" }}</td>
                            <td data-label="Type">{{ $item->type ?: "(blank)" }}</td>
                            <td data-label="Cost Price">{{ $item->cost_price ?: "(blank)" }}</td>
                            <td data-label="Selling Price">{{ $item->selling_price ?: "(blank)" }}</td>
                            <td data-label="Stock">{{ $item->stock ?: "(blank)" }}</td>

            <td data-label="Actions:" class="text-nowrap">
                                   @if($item->trashed())
    <form action="{{ route('items.restore', ['item' => $item]) }}" method="POST" class="d-inline-block me-2">
        @csrf
        @method('PUT')
        <input type="submit" name="restore" value="@lang('Restore')" class="btn btn-success btn-sm"/>
    </form>
    <form action="{{ route('items.purge', ['item' => $item]) }}" method="POST" class="d-inline-block">
        @csrf
        @method('DELETE')
        <input type="submit" name="purge" value="@lang('Purge')" class="btn btn-danger btn-sm"/>
    </form>
@else
    <a href="{{route('items.show', compact('item'))}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
<div class="btn-group btn-group-sm">
    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
    <ul class="dropdown-menu">
        <li><a class="dropdown-item" href="{{route('items.edit', compact('item'))}}">@lang('Edit')</a></li>
        <li>
            <form action="{{route('items.destroy', compact('item'))}}" method="POST" style="display: inline;" class="m-0 p-0">
                @csrf
                @method('DELETE')
                <button type="submit" class="dropdown-item">@lang('Delete')</button>
            </form>
        </li>
    </ul>
</div>

@endif

                            </td>
        </tr>
    @endforeach
    </tbody>
</table>

                {{ $items->withQueryString()->links() }}
            </div>
            <div class="text-center my-2">
                <a href="{{ route('items.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Item')</a>
            </div>
        </div>
    </div>
@endsection
