@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="{{ implode('/', ['','monthly_fillings']) }}"> Monthly Fillings</a></li>
                <li class="breadcrumb-item">@lang('Create new')</li>
            </ol>
        </div>

        <div class="card-body">
            <form action="{{ route('monthly_fillings.store', []) }}" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    @csrf
                    <div class="mb-3 col-md-6">
                        <label for="customer_id" class="form-label">Customer:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="customer_id" id="customer_id" class="form-control form-select flex-grow-1 select2" required>
                                <option value="" selected disabled>Select Customer</option>
                                @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ @old('customer_id') == $customer->id ? "selected" : "" }}>{{ $customer->name }}</option>
                                @endforeach
                            </select>

                            <!-- <a class="btn btn-light text-nowrap" href="{{ url('customers') }}"><i class="fa fa-plus-circle"></i> New</a> -->
                        </div>
                        @if($errors->has('customer_id'))
                        <div class='error small text-danger'>{{$errors->first('customer_id')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="month" class="form-label">Month:</label>
                        <input type="date" name="month" id="month" class="form-control" value="{{@old('month')}}"/>
                        @if($errors->has('month'))
                        <div class='error small text-danger'>{{$errors->first('month')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="standard_sales" class="form-label">Standard Sales:</label>
                        <input type="text" name="standard_sales" id="standard_sales" class="form-control" value="{{@old('standard_sales')}}" />
                        @if($errors->has('standard_sales'))
                        <div class='error small text-danger'>{{$errors->first('standard_sales')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="deemed_sales" class="form-label">Deemed Sales:</label>
                        <input type="text" name="deemed_sales" id="deemed_sales" class="form-control" value="{{@old('deemed_sales')}}" />
                        @if($errors->has('deemed_sales'))
                        <div class='error small text-danger'>{{$errors->first('deemed_sales')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="zero_rated_sales" class="form-label">Zero Rated Sales:</label>
                        <input type="text" name="zero_rated_sales" id="zero_rated_sales" class="form-control" value="{{@old('zero_rated_sales')}}" />
                        @if($errors->has('zero_rated_sales'))
                        <div class='error small text-danger'>{{$errors->first('zero_rated_sales')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="exempted_sales" class="form-label">Exempted Sales:</label>
                        <input type="text" name="exempted_sales" id="exempted_sales" class="form-control" value="{{@old('exempted_sales')}}" />
                        @if($errors->has('exempted_sales'))
                        <div class='error small text-danger'>{{$errors->first('exempted_sales')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="purchases" class="form-label">Purchases:</label>
                        <input type="text" name="purchases" id="purchases" class="form-control" value="{{@old('purchases')}}" />
                        @if($errors->has('purchases'))
                        <div class='error small text-danger'>{{$errors->first('purchases')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="non_vat_urchases" class="form-label">Non VAT Purchases:</label>
                        <input type="text" name="non_vat_purchases" id="non_vat_purchases" class="form-control number_format" value="{{@old('non_vat_purchases')}}" />
                        @if($errors->has('non_vat_purchases'))
                        <div class='error small text-danger'>{{$errors->first('non_vat_purchases')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="imports" class="form-label">Imports:</label>
                        <input type="text" name="imports" id="imports" class="form-control" value="{{@old('imports')}}" />
                        @if($errors->has('imports'))
                        <div class='error small text-danger'>{{$errors->first('imports')}}</div>
                        @endif
                    </div>
                    {{-- <div class="mb-3">
                        <label for="net_sales" class="form-label">Net Sales:</label>
                        <input type="number" name="net_sales" id="net_sales" class="form-control" value="{{@old('net_sales')}}" required/>
                        @if($errors->has('net_sales'))
                        <div class='error small text-danger'>{{$errors->first('net_sales')}}</div>
                        @endif
                    </div>
                    <div class="mb-3">
                        <label for="output_vat" class="form-label">Output Vat:</label>
                        <input type="number" name="output_vat" id="output_vat" class="form-control" value="{{@old('output_vat')}}" required/>
                        @if($errors->has('output_vat'))
                        <div class='error small text-danger'>{{$errors->first('output_vat')}}</div>
                        @endif
                    </div>
                    <div class="mb-3">
                        <label for="gross_sales" class="form-label">Gross Sales:</label>
                        <input type="number" name="gross_sales" id="gross_sales" class="form-control" value="{{@old('gross_sales')}}" required/>
                        @if($errors->has('gross_sales'))
                        <div class='error small text-danger'>{{$errors->first('gross_sales')}}</div>
                        @endif
                    </div> --}}
                    <div class="mb-3 col-md-6">
                        <label for="filling_date" class="form-label">Filling Date:</label>
                        <input type="date" name="filling_date" id="filling_date" class="form-control" value="{{@old('filling_date')}}" />
                        @if($errors->has('filling_date'))
                        <div class='error small text-danger'>{{$errors->first('filling_date')}}</div>
                        @endif
                    </div>
                    {{-- <div class="mb-3">
                        <label for="users_id" class="form-label">Users:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="users_id" id="users_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Users</option>
                                @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ @old('users_id') == $user->id ? "selected" : "" }}>{{ $user->name }}</option>
                                @endforeach
                            </select>

                            <a class="btn btn-light text-nowrap" href="{{implode('/', ['','users','create'])}}"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        @if($errors->has('users_id'))
                        <div class='error small text-danger'>{{$errors->first('users_id')}}</div>
                        @endif
                    </div> --}}

                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="{{ route('monthly_fillings.index', []) }}" class="btn btn-light">@lang('Cancel')</a>
                        <button type="submit" class="btn btn-primary">@lang('Create new Monthly Filling')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
