@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Monthly Fillings</h5>
            <a href="{{ route('monthly_fillings.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Monthly Filling')</a>
        </div>

        <!-- Filters Section -->
        <div class="card-body">
            <div class="row mb-3">
                <!-- Customer Filter -->
                <div class="col-md-4">
                    <label for="filterCustomer" class="form-label">Filter by Customer:</label>
                    <select id="filterCustomer" class="form-control select2">
                        <option value="">All</option>
                        @foreach($customers as $customer)
                            <option value="{{ $customer->name }}">{{ $customer->name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Month Filter Dropdown -->
                <div class="col-md-4">
                    <label for="filterMonth" class="form-label">Filter by Month:</label>
                    <select id="filterMonth" class="form-control">
                        <option value="">All</option>
                        <option value="Jan">January</option>
                        <option value="Feb">February</option>
                        <option value="Mar">March</option>
                        <option value="Apr">April</option>
                        <option value="May">May</option>
                        <option value="Jun">June</option>
                        <option value="Jul">July</option>
                        <option value="Aug">August</option>
                        <option value="Sep">September</option>
                        <option value="Oct">October</option>
                        <option value="Nov">November</option>
                        <option value="Dec">December</option>
                    </select>
                </div>

                <!-- Year Filter Dropdown -->
                <div class="col-md-4">
                    <label for="filterYear" class="form-label">Filter by Year:</label>
                    <select id="filterYear" class="form-control">
                        <option value="">All</option>
                        <option value="2022">2022</option>
                        <option value="2022">2023</option>
                        <option value="2022">2024</option>
                        <option value="2022">2025</option>
                    </select>
                </div>
            </div>

            <!-- DataTable -->
            <table class="table table-striped table-responsive table-hover dataTable" id="monthlyFillingTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Month</th>
                        <th role='columnheader'>Purchases</th>
                        <th role='columnheader'>Sales</th>
                        <th role='columnheader'>Resultant VAT</th>
                        <th role='columnheader'>User</th>
                        <th role="columnheader">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($monthlyFillings as $monthlyFilling)
                    <tr>
                        <td data-label="Customer">
                            <a href="{{ url('customers/'.$monthlyFilling->customer_id ?: 0)}}" class="text-dark">
                                {{$monthlyFilling?->customer?->name ?: "(blank)"}}</a>
                        </td>
                        <td data-label="Month">{{ date('M-Y', strtotime($monthlyFilling->month)) ?: "0" }}</td>
                        <td data-label="Purchases">{{ number_format($monthlyFilling->purchases) ?: "0" }}</td>
                        <td data-label="Gross Sales">{{ number_format($monthlyFilling->gross_sales) ?: "0" }}</td>
                        <td data-label="VAT">{{ number_format($monthlyFilling->output_vat) ?: "0" }}</td>
                        <td data-label="User">{{ $monthlyFilling->user->name }}</td>
                        <td data-label="Actions" class="text-nowrap">
                            <a href="{{ url('monthly_fillings/'.$monthlyFilling->id)}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
                            <div class="btn-group btn-group-sm">
                                <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="{{route('monthly_fillings.edit', $monthlyFilling->id)}}">@lang('Edit')</a></li>
                                    <li>
                                        <form action="{{route('monthly_fillings.destroy', $monthlyFilling->id)}}" method="POST" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="dropdown-item">@lang('Delete')</button>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#monthlyFillingTable').DataTable({
        "dom": 't<"d-flex justify-content-between"<"i"l><"p"p>>',
        "pageLength": 10,
    });

    // Filter Customer
    $('#filterCustomer').on('change', function () {
        table.column(0).search($(this).val()).draw();
    });

    // Filter Month
    $('#filterMonth').on('change', function () {
        let selectedMonth = $(this).val();
        if (selectedMonth) {
            table.column(1).search(selectedMonth).draw();
        } else {
            table.column(1).search('').draw();
        }
    });

    // Filter Year
    $('#filterYear').on('change', function () {
        let selectedYear = $(this).val();
        if (selectedYear) {
            table.column(1).search(selectedYear).draw();
        } else {
            table.column(1).search('').draw();
        }
    });

    // Combine Month and Year Filters
    $('#filterMonth, #filterYear').on('change', function () {
        let selectedMonth = $('#filterMonth').val();
        let selectedYear = $('#filterYear').val();
        let searchValue = '';

        if (selectedMonth && selectedYear) {
            searchValue = selectedMonth + '-' + selectedYear;
        } else if (selectedMonth) {
            searchValue = selectedMonth;
        } else if (selectedYear) {
            searchValue = selectedYear;
        }

        table.column(1).search(searchValue).draw();
    });
});
</script>
@endsection
