@extends('layouts.app')

@section('content')
<!-- <div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="{{ implode('/', ['','monthly_fillings']) }}"> Monthly Fillings</a></li>
                <li class="breadcrumb-item">@lang('Monthly Filling') #{{$monthlyFilling->id}}</li>
            </ol>

            <a href="{{ route('monthly_fillings.index', []) }}" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
        </div>

        <div class="card-body">
            <table class="table table-striped">
                <tbody>
                    <tr>
                        <th scope="row">ID:</th>
                        <td>{{$monthlyFilling->id}}</td>
                    </tr>
                    <tr>
                        <th scope="row">Customer:</th>
                        <td><a href="{{implode('/', ['','customers',$monthlyFilling->customer_id ?: 0])}}" class="text-dark">{{$monthlyFilling?->customer?->name ?: "(blank)"}}</a></td>
                    </tr>
                    <tr>
                        <th scope="row">Month:</th>
                        <td>{{ date('M - Y',strtotime($monthlyFilling->month)) ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Standard Sales:</th>
                        <td>{{ $monthlyFilling->standard_sales ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Deemed Sales:</th>
                        <td>{{ $monthlyFilling->deemed_sales ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Zero Rated Sales:</th>
                        <td>{{ $monthlyFilling->zero_rated_sales ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Exempted Sales:</th>
                        <td>{{ $monthlyFilling->exempted_sales ?: "(blank)" }}</td>
                    </tr>
                    <tr>
                        <th scope="row">Purchases:</th>
                        <td>{{ $monthlyFilling->purchases ?: "(blank)" }}</td>
                    </tr>
                </tr>
                <tr>
                    <th scope="row">Non VAT Purchases:</th>
                    <td>{{ $monthlyFilling->non_vat_purchases ?: "(blank)" }}</td>
                </tr>
            </tr>
            <tr>
                <th scope="row">Imports:</th>
                <td>{{ $monthlyFilling->imports ?: "(blank)" }}</td>
            </tr>
            <tr>
                <th scope="row">Net Sales:</th>
                <td>{{ $monthlyFilling->net_sales ?: "(blank)" }}</td>
            </tr>
            <tr>
                <th scope="row">Output Vat:</th>
                <td>{{ $monthlyFilling->output_vat ?: "(blank)" }}</td>
            </tr>
            <tr>
                <th scope="row">Gross Sales:</th>
                <td>{{ $monthlyFilling->gross_sales ?: "(blank)" }}</td>
            </tr>
            <tr>
                <th scope="row">Filling Date:</th>
                <td>{{ $monthlyFilling->filling_date ?: "(blank)" }}</td>
            </tr>
            <tr>
                <th scope="row">Created at</th>
                <td>{{Carbon\Carbon::parse($monthlyFilling->created_at)->format('d/m/Y H:i:s')}}</td>
            </tr>
            <tr>
                <th scope="row">Updated at</th>
                <td>{{Carbon\Carbon::parse($monthlyFilling->updated_at)->format('d/m/Y H:i:s')}}</td>
            </tr>
        </tbody>
    </table>

</div>

<div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
    <a href="{{ route('monthly_fillings.edit', $monthlyFilling->id) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
    <form action="{{ route('monthly_fillings.destroy', $monthlyFilling->id) }}" method="POST" class="m-0 p-0">
        @csrf
        @method('DELETE')
        <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
    </form>
</div>
</div>
</div> -->
<div class="card">
    <div class="card-header d-flex flex-row align-items-center justify-content-between">
        <h5>{{ $monthlyFilling->customer->name }}</h5>

        <span class="badge bg-primary">{{ date('M - Y',strtotime($monthlyFilling->month)) }}</span>
    </div>
    <div class="card-body">
        <table class="table table-striped">
            <thead>
                <th>Item</th>
                <th class="text-end">Amount</th>
            </thead>
            <tbody>
                <tr>
                    <td>Standard Sales</td>
                    <td class="text-end">{{ number_format($monthlyFilling->standard_sales) }}</td>
                </tr>
                <tr>
                    <td>Exempted Sales</td>
                    <td class="text-end">{{ number_format($monthlyFilling->exempted_sales) }}</td>
                </tr>
                <tr>
                    <td>Zero Rated Sales</td>
                    <td class="text-end">{{ number_format($monthlyFilling->zero_rated_sales) }}</td>
                </tr>
                <tr>
                    <td>Deemed Sales</td>
                    <td class="text-end">{{ number_format($monthlyFilling->deemed_sales) }}</td>
                </tr>
                <tr>
                    <th>Output VAT</th>
                    <th class="text-end">{{ number_format($monthlyFilling->standard_sales * 0.18) }}</th>
                </tr>
                <tr>
                    <td>Standard Purchases</td>
                    <td class="text-end">{{ number_format($monthlyFilling->purchases) }}</td>
                </tr>
                <tr>
                    <td>Non VAT Purchases</td>
                    <td class="text-end">{{ number_format($monthlyFilling->non_vat_purchases) }}</td>
                </tr>
                <tr>
                    <td>Imports</td>
                    <td class="text-end">{{ number_format($monthlyFilling->imports) }}</td>
                </tr>
                <tr>
                    <th>Input VAT</th>
                    <th class="text-end">{{ number_format(($monthlyFilling->purchases * 0.18) + ($monthlyFilling->imports * 0.18)) }}</th>
                </tr>
                    <td>Resultant VAT</td>
                    <td class="text-end">{{ number_format(($monthlyFilling->standard_sales * 0.18) - (($monthlyFilling->purchases * 0.18) + ($monthlyFilling->imports * 0.18))) }}</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
@endsection
