@extends('purchase_payments.layout')

@section('purchasePayments.content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Purchase Payment</h5>

            <a href="{{ route('purchase_payments.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create New Purchase Payment')</a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Purchase</th>
                        <th role='columnheader'>Payment Method</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Balance</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($purchasePayments as $purchasePayment)
                    <tr>
                        <td data-label="Purchase"><a href="{{implode('/', ['','purchases',$purchasePayment->purchase_id ?: 0])}}" class="text-dark">{{$purchasePayment?->purchase?->item?->name ?: "(blank)"}}</a></td>
                        <td data-label="Payment Method"><a href="{{implode('/', ['','payment_methods',$purchasePayment->payment_method_id ?: 0])}}" class="text-dark">{{$purchasePayment?->payment_method?->name ?: "(blank)"}}</a></td>
                        <td data-label="Amount">{{ $purchasePayment->amount ?: "(blank)" }}</td>
                        <td data-label="Balance">{{ $purchasePayment->balance ?: "0" }}</td>

                        <td data-label="Actions:" class="text-nowrap">
                         @if($purchasePayment->trashed())
                         <form action="{{ route('purchase_payments.restore', ['purchasePayment' => $purchasePayment]) }}" method="POST" class="d-inline-block me-2">
                            @csrf
                            @method('PUT')
                            <input type="submit" name="restore" value="@lang('Restore')" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="{{ route('purchase_payments.purge', ['purchasePayment' => $purchasePayment]) }}" method="POST" class="d-inline-block">
                            @csrf
                            @method('DELETE')
                            <input type="submit" name="purge" value="@lang('Purge')" class="btn btn-danger btn-sm"/>
                        </form>
                        @else
                       {{--  <a href="{{route('purchase_payments.show', compact('purchasePayment'))}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{route('purchase_payments.edit', compact('purchasePayment'))}}">@lang('Edit')</a></li>
                                <li>
                                    <form action="{{route('purchase_payments.destroy', compact('purchasePayment'))}}" method="POST" style="display: inline;" class="m-0 p-0">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="dropdown-item">@lang('Delete')</button>
                                    </form>
                                </li>
                            </ul>
                        </div> --}}

                        @endif

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        {{-- {{ $purchasePayments->withQueryString()->links() }} --}}
    </div>
    <div class="text-center my-2">
        {{-- <a href="{{ route('purchase_payments.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Purchase Payment')</a> --}}
    </div>
</div>
</div>
@endsection
