@extends('purchase_payments.layout')

@section('purchasePayments.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','purchase_payments']) }}"> Purchase Payments</a></li>
                    <li class="breadcrumb-item">@lang('Purchase Payment') #{{$purchasePayment->id}}</li>
                </ol>

                <a href="{{ route('purchase_payments.index', []) }}" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
            </div>

            <div class="card-body">
                <table class="table table-striped">
    <tbody>
    <tr>
        <th scope="row">ID:</th>
        <td>{{$purchasePayment->id}}</td>
    </tr>
            <tr>
            <th scope="row">Purchase:</th>
            <td><a href="{{implode('/', ['','purchases',$purchasePayment->purchase_id ?: 0])}}" class="text-dark">{{$purchasePayment?->purchase?->amount ?: "(blank)"}}</a></td>
        </tr>
            <tr>
            <th scope="row">Payment Method:</th>
            <td><a href="{{implode('/', ['','payment_methods',$purchasePayment->payment_method_id ?: 0])}}" class="text-dark">{{$purchasePayment?->payment_method?->name ?: "(blank)"}}</a></td>
        </tr>
            <tr>
            <th scope="row">Amount:</th>
            <td>{{ $purchasePayment->amount ?: "(blank)" }}</td>
        </tr>
            <tr>
            <th scope="row">Balance:</th>
            <td>{{ $purchasePayment->balance ?: "(blank)" }}</td>
        </tr>
                <tr>
            <th scope="row">Created at</th>
            <td>{{Carbon\Carbon::parse($purchasePayment->created_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        <tr>
            <th scope="row">Updated at</th>
            <td>{{Carbon\Carbon::parse($purchasePayment->updated_at)->format('d/m/Y H:i:s')}}</td>
        </tr>
        </tbody>
</table>

            </div>

            <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
                <a href="{{ route('purchase_payments.edit', compact('purchasePayment')) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
                <form action="{{ route('purchase_payments.destroy', compact('purchasePayment')) }}" method="POST" class="m-0 p-0">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
                </form>
            </div>
        </div>
    </div>
@endsection
