@extends('purchases.layout')

@section('purchases.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','purchases']) }}"> Purchases</a></li>
                    <li class="breadcrumb-item">@lang('Edit Purchase') #{{$purchase->id}}</li>
                </ol>
            </div>
            <div class="card-body">
                <form action="{{ route('purchases.update', compact('purchase')) }}" method="POST" class="m-0 p-0">
                    @method('PUT')
                    @csrf
                    <div class="card-body">
                        <div class="mb-3">
        <label for="supplier_id" class="form-label">Supplier:</label>
        <div class="d-flex flex-row align-items-center justify-content-between">
    <select name="supplier_id" id="supplier_id" class="form-control form-select flex-grow-1" required>
        <option value="" selected disabled>Select Supplier</option>
        @foreach($suppliers as $supplier)
            <option value="{{ $supplier->id }}" {{ @old('supplier_id', $purchase->supplier_id) == $supplier->id ? "selected" : "" }}>{{ $supplier->name }}</option>
        @endforeach
    </select>

    <a class="btn btn-light text-nowrap" href="{{implode('/', ['','suppliers','create'])}}"><i class="fa fa-plus-circle"></i> New</a>
</div>
        @if($errors->has('supplier_id'))
			<div class='error small text-danger'>{{$errors->first('supplier_id')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="items_id" class="form-label">Items:</label>
        <div class="d-flex flex-row align-items-center justify-content-between">
    <select name="items_id" id="items_id" class="form-control form-select flex-grow-1" required>
        <option value="" selected disabled>Select Items</option>
        @foreach($items as $item)
            <option value="{{ $item->id }}" {{ @old('items_id', $purchase->items_id) == $item->id ? "selected" : "" }}>{{ $item->sku }}</option>
        @endforeach
    </select>

    <a class="btn btn-light text-nowrap" href="{{implode('/', ['','items','create'])}}"><i class="fa fa-plus-circle"></i> New</a>
</div>
        @if($errors->has('items_id'))
			<div class='error small text-danger'>{{$errors->first('items_id')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="payment_method_id" class="form-label">Payment Method:</label>
        <div class="d-flex flex-row align-items-center justify-content-between">
    <select name="payment_method_id" id="payment_method_id" class="form-control form-select flex-grow-1" required>
        <option value="" selected disabled>Select Payment Method</option>
        @foreach($paymentMethods as $paymentMethod)
            <option value="{{ $paymentMethod->id }}" {{ @old('payment_method_id', $purchase->payment_method_id) == $paymentMethod->id ? "selected" : "" }}>{{ $paymentMethod->name }}</option>
        @endforeach
    </select>

    <a class="btn btn-light text-nowrap" href="{{implode('/', ['','paymentMethods','create'])}}"><i class="fa fa-plus-circle"></i> New</a>
</div>
        @if($errors->has('payment_method_id'))
			<div class='error small text-danger'>{{$errors->first('payment_method_id')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="amount" class="form-label">Amount:</label>
        <input type="text" name="amount" id="amount" class="form-control" value="{{@old('amount', $purchase->amount)}}" required/>
        @if($errors->has('amount'))
			<div class='error small text-danger'>{{$errors->first('amount')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="balance" class="form-label">Balance:</label>
        <input type="text" name="balance" id="balance" class="form-control" value="{{@old('balance', $purchase->balance)}}" required/>
        @if($errors->has('balance'))
			<div class='error small text-danger'>{{$errors->first('balance')}}</div>
		@endif
    </div>

                    </div>
                    <div class="card-footer">
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <a href="{{ route('purchases.index', []) }}" class="btn btn-light">Cancel</a>
                            <button type="submit" class="btn btn-primary">@lang('Update Purchase')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
