@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-body">
		<form class="row">
			<div class="col-md-3">
				<label>Start Date</label>
				<input type="date" name="start_date" class="form-control" value="{{ ($request->start_date) ? $request->start_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>End Date</label>
				<input type="date" name="end_date" class="form-control" value="{{ ($request->end_date) ? $request->end_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>User</label>
				<select class="form-select select2" name="user[]" multiple>
					@foreach($users as $user)
						<option value="{{ $user->id }}" {{ ($request->user) ? (in_array($user->id,$request->user) ? 'selected':''):''  }}>{{ $user->name }}</option>
					@endforeach
				</select>
			</div>
			<div class="col-md-3">
				<label></label>
				<button type="submit" class="btn btn-primary">Search</button>
				<button type="submit" class="btn btn-warning" name="download" value="pdf">PDF</button>
			</div>
		</form>
	</div>
</div>
<div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Expenses</h5>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover table-bordered dataTable">
                <thead role="rowgroup bg-light">
                    <tr role="row">
                        <th role='columnheader'>Date</th>
                        <th role='columnheader'>Item</th>
                        <th role='columnheader'>Payment Method</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Made By</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($expenses as $expense)
                    <tr>
                        <td>{{ date('d M, Y',strtotime($expense->created_at)) }}</td>
                        <td data-label="Customer"><a href="{{implode('/', ['','expense_items',$expense->expense_id ?: 0])}}" class="text-dark">{{$expense?->expense_item?->name ?: "(blank)"}}</a></td>
                        <td data-label="Payment_Method"><a href="{{implode('/', ['','payment_methods',$expense->payment_method_id ?: 0])}}" class="text-dark">{{$expense?->payment_method?->name ?: "(blank)"}}</a></td>
                        <td data-label="Gross Amount">{{ number_format($expense->amount) ?: "0" }}</td>
                        <td data-label="Sales Person">{{ $expense?->user?->name ?: "(blank)" }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection