@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-body">
		<form class="row">
			<div class="col-md-3">
				<label>Start Date</label>
				<input type="date" name="start_date" class="form-control" value="{{ ($request->start_date) ? $request->start_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>End Date</label>
				<input type="date" name="end_date" class="form-control" value="{{ ($request->end_date) ? $request->end_date : date('Y-m-d') }}" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>User</label>
				<select class="form-select select2" name="user[]" multiple>
					@foreach($users as $user)
						<option value="{{ $user->id }}" {{ ($request->user) ? (in_array($user->id,$request->user) ? 'selected':''):''  }}>{{ $user->name }}</option>
					@endforeach
				</select>
			</div>
			<div class="col-md-3">
				<label></label>
				<button type="submit" class="btn btn-primary">Search</button>
				<button type="submit" class="btn btn-warning" name="download" value="pdf">PDF</button>
			</div>
		</form>
	</div>
</div>
<div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Invoices</h5>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover table-bordered dataTable">
                <thead role="rowgroup bg-light">
                    <tr role="row">
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Issue Date</th>
                        <th role='columnheader'>Gross Amount</th>
                        <th role='columnheader'>Sales Person</th>
                        <th role='columnheader'>Status</th>
                        <th role='columnheader'>Created By</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($invoices as $invoice)
                    <tr>
                        <td data-label="Invoice No">INV{{ sprintf("%05d",$invoice->invoice_no) ?: "(blank)" }}</td>
                        <td data-label="Customer"><a href="{{implode('/', ['','customers',$invoice->customer_id ?: 0])}}" class="text-dark">{{$invoice?->customer?->name ?: "(blank)"}}</a></td>
                        <td data-label="Issue Date">{{ $invoice->issue_date ?: "(blank)" }}</td>
                        <td data-label="Gross Amount">{{ number_format($invoice->gross_amount) ?: "(blank)" }}</td>
                        <td data-label="Sales Person">{{ $invoice->sales_person ?: "(blank)" }}</td>
                        <td data-label="Status">
                            <span class="badge {{ ($invoice->status == "Completed") ? "bg-primary" : "bg-warning" }}">{{ $invoice->status ?: "(blank)" }}</span>
                        </td>
                        <td data-label="Created By">{{ $invoice->user->name ?: "(blank)" }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection