<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style>
		.text-center{
			text-align: center;
		}

		.text-left{
			text-align: left;
		}

		.bold{
			font-weight: bold;
		}

		.heading{
			margin: 20px;
		}
		table{
			border-collapse: collapse;
		}
		thead{
			color: white;
			background: black;
			border-collapse: collapse;
		}
		.item:nth-child(even) {
			background-color: #f2f2f2;
		}
	</style>
</head>
<body>
	<div class="heading">
		<div class="text-center">
			<div class="bold">WYKA CONSULTING GROUP</div>
			<div>Addres: Arua Park Plaza</div>
			<div>Email: finance@wykaconsults.com</div>
			<div>Website: wykaconsults.com</div>
			<div>Tel: +256 784 326279</div>
		</div>
	</div>
	<div class="text-center">
		<div class="bold">Expenses Report</div>
		<div>
			From {{ date('M d, Y',strtotime($request->start_date)).' To '.date('M d, Y',strtotime($request->end_date)) }}
		</div>
	</div>
	<div class="heading">
		<table style="width: 100%;">
			<thead>
                        <th role='columnheader'>Date</th>
                        <th role='columnheader'>Item</th>
                        <th role='columnheader'>Payment Method</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Made By</th>
			</thead>
			<tbody>
				@php
				$total = 0;
				@endphp
				@foreach($expenses as $expense)
				@php
				$total += $expense->amount;
				@endphp
				<tr class="item">
				<td>{{ date('d M, Y',strtotime($expense->created_at)) }}</td>
                        <td data-label="Customer">{{$expense?->expense_item?->name ?: "(blank)"}}</td>
                        <td data-label="Payment_Method">{{$expense?->payment_method?->name ?: "(blank)"}}</td>
                        <td data-label="Gross Amount">{{ number_format($expense->amount) ?: "0" }}</td>
                        <td data-label="Sales Person">{{ $expense?->user?->name ?: "(blank)" }}</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
	<div class="heading">
		<table width="100%">
			<tr>
				<td width="60%"></td>
				<td>

					<div style="background: #fffafa; border-radius: 7px; padding:10px">
						<table style="width:100%;">
						<tr>
							<td class="bold">
								Total Amount
							</td>
							<td class="text-left">{{ number_format($total) }}</td>
						</tr>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
</body>
</html>