@extends('layouts.app')

@section('content')
<div class="col-xxl-9">
    <div class="card">
        <form class="needs-validation repeater" action="{{ route('invoices.store', []) }}" method="POST" novalidate id="invoice_form">
            @csrf
            <div class="card-body border-bottom border-bottom-dashed p-4">
                <div class="row">
                    <input type="hidden" name="invoice_id" value="{{ \Str::uuid() }}">
                    <div class="col-lg-4">
                        <div class="form-group  mb-3">
                            <select class="customers form-control" name="customer" required>
                                <option value="" selected disabled>Select Customer</option>
                                @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ (old("customer") == $customer->id) ? 'selected' : '' }}>{{ $customer->name }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback">
                                Customer is required
                            </div>
                            {{-- <input id="profile-img-file-input" type="file" class="profile-img-file-input" />
                            <label for="profile-img-file-input" class="d-block" tabindex="0">
                                <span class="overflow-hidden border border-dashed d-flex align-items-center justify-content-center rounded" style="height: 60px; width: 256px;">
                                    <img src="{{ asset('assets/images/logo-dark.png') }}" class="card-logo card-logo-dark user-profile-image img-fluid" alt="logo dark">
                                    <img src="{{ asset('assets/images/logo-light.png') }}" class="card-logo card-logo-light user-profile-image img-fluid" alt="logo light">
                                </span>
                            </label> --}}
                        </div>
                       {{--  <div>
                            <div>
                                <label for="companyAddress">Address</label>
                            </div>
                            <div class="mb-2">
                                <textarea class="form-control bg-light border-0" id="companyAddress" rows="3" placeholder="Company Address" required></textarea>
                                <div class="invalid-feedback">
                                    Please enter a address
                                </div>
                            </div>
                            <div>
                                <input type="text" class="form-control bg-light border-0" id="companyaddpostalcode" minlength="5" maxlength="6" placeholder="Enter Postal Code" required />
                                <div class="invalid-feedback">
                                    The US zip code must contain 5 digits, Ex. 45678
                                </div>
                            </div>
                        </div> --}}
                    </div>
                    <!--end col-->
                    <div class="col-lg-4 ms-auto">
                        <div class="mb-2">
                            <input type="text" class="form-control bg-light border-0" id="registrationNumber" maxlength="12" placeholder="Legal Registration No" value="WYKA Consulting Group" disabled  />
                        </div>
                        <div class="mb-2">
                            <input type="email" class="form-control bg-light border-0" id="companyEmail" placeholder="Email Address" value="finance@wykaconsults.com" disabled />
                            <div class="invalid-feedback">
                                Please enter a valid email, Ex., example@gamil.com
                            </div>
                        </div>
                        <div class="mb-2">
                            <input type="text" class="form-control bg-light border-0" id="companyWebsite" placeholder="Website" value="wykaconsults.com" required disabled />
                            <div class="invalid-feedback">
                                Please enter a website, Ex., www.example.com
                            </div>
                        </div>
                        <div>
                            <input type="text" class="form-control bg-light border-0" data-plugin="cleave-phone" id="compnayContactno" placeholder="Contact No" value="07888384" disabled required />
                            <div class="invalid-feedback">
                                Please enter a contact number
                            </div>
                        </div>
                    </div>
                </div>
                <!--end row-->
            </div>
            <div class="card-body p-4">
                <div class="row g-3">
                    <div class="col-lg-4 col-sm-6">
                        <label for="invoicenoInput">Invoice No</label>
                        <input type="text" class="form-control bg-light border-0" id="invoicenoInput" placeholder="Invoice No" value="#INV{{ $invoice_no }}" readonly="readonly" />
                    </div>
                    <!--end col-->
                    <div class="col-lg-4 col-sm-6">
                        <div>
                            <label for="date-field">Due Date</label>
                            <input type="text" class="form-control bg-light border-0" id="date-field" data-provider="flatpickr" name="due_date" value="{{ old('due_date',date("Y-m-d",strtotime("+7 day"))) }}" data-time="true" placeholder="Select Date Invoice Due Date">
                        </div>
                    </div>
                    <!--end col-->
                    <div class="col-lg-4 col-sm-6">
                        <div>
                            <label for="totalamountInput">Total Amount</label>
                            <input type="text" class="form-control grand_total bg-light border-0" id="totalamountInput" placeholder="UGX 0.00" readonly />
                        </div>
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->
            </div>
           {{--  <div class="card-body p-4 border-top border-top-dashed">
                <div class="row">
                    <div class="col-lg-4 col-sm-6">
                        <div>
                            <label for="billingName" class="text-muted text-uppercase fw-semibold">Billing Address</label>
                        </div>
                        <div class="mb-2">
                            <input type="text" class="form-control bg-light border-0" id="billingName" placeholder="Full Name" required />
                            <div class="invalid-feedback">
                                Please enter a full name
                            </div>
                        </div>
                        <div class="mb-2">
                            <textarea class="form-control bg-light border-0" id="billingAddress" rows="3" placeholder="Address" required></textarea>
                            <div class="invalid-feedback">
                                Please enter a address
                            </div>
                        </div>
                        <div class="mb-2">
                            <input type="text" class="form-control bg-light border-0" data-plugin="cleave-phone" id="billingPhoneno" placeholder="(123)456-7890" required />
                            <div class="invalid-feedback">
                                Please enter a phone number
                            </div>
                        </div>
                        <div class="mb-3">
                            <input type="text" class="form-control bg-light border-0" id="billingTaxno" placeholder="Tax Number" required />
                            <div class="invalid-feedback">
                                Please enter a tax number
                            </div>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="same" name="same" onchange="billingFunction()" />
                            <label class="form-check-label" for="same">
                                Will your Billing and Shipping address same?
                            </label>
                        </div>
                    </div>
                    <!--end col-->
                    <div class="col-sm-6 ms-auto">
                        <div class="row">
                            <div class="col-lg-8">
                                <div>
                                    <label for="shippingName" class="text-muted text-uppercase fw-semibold">Shipping Address</label>
                                </div>
                                <div class="mb-2">
                                    <input type="text" class="form-control bg-light border-0" id="shippingName" placeholder="Full Name" required />
                                    <div class="invalid-feedback">
                                        Please enter a full name
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <textarea class="form-control bg-light border-0" id="shippingAddress" rows="3" placeholder="Address" required></textarea>
                                    <div class="invalid-feedback">
                                        Please enter a address
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <input type="text" class="form-control bg-light border-0" data-plugin="cleave-phone" id="shippingPhoneno" placeholder="(123)456-7890" required />
                                    <div class="invalid-feedback">
                                        Please enter a phone number
                                    </div>
                                </div>
                                <div>
                                    <input type="text" class="form-control bg-light border-0" id="shippingTaxno" placeholder="Tax Number" required />
                                    <div class="invalid-feedback">
                                        Please enter a tax number
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->
            </div> --}}
            <div class="card-body p-4">
                <div class="table-responsive">
                    <table class="invoice-table table table-borderless table-nowrap mb-0">
                        <thead class="align-middle">
                            <tr class="table-active">
                                <th scope="col">
                                    Product Details
                                </th>
                                <th scope="col" style="width: 170px;">
                                    <div class="d-flex currency-select input-light align-items-center">
                                        Rate
                                        
                                    </div>
                                </th>
                                <th scope="col" style="width: 120px;">Quantity</th>
                                <th scope="col" class="text-end" style="width: 150px;">Amount</th>
                                <th scope="col" class="text-end" style="width: 105px;"></th>
                            </tr>
                        </thead>
                        <tbody data-repeater-list="items">
                            <tr id="1" class="product" data-repeater-item>
                                <td class="text-start">
                                    <div class="mb-2">
                                        <select class="form-control bg-light form-select items" name="item">
                                            <option value="" selected disabled>Please Select Item</option>
                                            @foreach($items as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <textarea class="form-control bg-light border-0" name="description" rows="2" placeholder="Item Details"></textarea>
                                </td>
                                <td>
                                    <input type="text" class="form-control unit_price bg-light border-0" id="productRate-1" name="unit_price" placeholder="0.00" required />
                                    <div class="invalid-feedback">
                                        Please enter a rate
                                    </div>
                                </td>
                                <td>
                                    <input type="text" name="quantity" class="form-control quantity bg-light border-0" id="productRate-1" placeholder="1" required />
                                    <div class="invalid-feedback">
                                        Please enter a quantity
                                    </div>
                                </td>
                                <td class="text-end">
                                    <div>
                                        <input type="text" class="form-control item_total bg-light border-0 product-line-price" name="item_total" id="productPrice-1" placeholder="UGX 0.00" readonly />
                                    </div>
                                </td>
                                <td class="product-removal">
                                    <a data-repeater-delete href="javascript:void(0)" class="btn btn-success">Delete</a>
                                </td>
                            </tr>
                        </tbody>
                        <tbody>
                            <tr id="newForm" style="display: none;"><td class="d-none" colspan="5"><p>Add New Form</p></td></tr>
                            <tr>
                                <td colspan="5">
                                    <a href="javascript:void(0)" id="add-item" class="btn btn-soft-secondary fw-medium" data-repeater-create><i class="ri-add-fill me-1 align-bottom"></i> Add Item</a>
                                </td>
                            </tr>
                            <tr class="border-top border-top-dashed mt-2">
                                <td colspan="3"></td>
                                <td colspan="2" class="p-0">
                                    <table class="table table-borderless table-sm table-nowrap align-middle mb-0">
                                        <tbody>
                                            <tr>
                                                <th scope="row">Sub Total</th>
                                                <td style="width:150px;">
                                                    <input type="text" class="form-control bg-light border-0" id="cart-subtotal" placeholder="UGX 0.00" readonly />
                                                </td>
                                            </tr>
                                            <tr>
                                                <th scope="row">Estimated Tax (0%)</th>
                                                <td>
                                                    <input type="text" class="form-control bg-light border-0" id="cart-tax" placeholder="UGX 0.00" readonly />
                                                </td>
                                            </tr>
                                           {{--  <tr>
                                                <th scope="row">Discount <small class="text-muted">(VELZON15)</small></th>
                                                <td>
                                                    <input type="text" class="form-control bg-light border-0" id="cart-discount" placeholder="$0.00" readonly />
                                                </td>
                                            </tr> 
                                            <tr>
                                                <th scope="row">Shipping Charge</th>
                                                <td>
                                                    <input type="text" class="form-control bg-light border-0" id="cart-shipping" placeholder="$0.00" readonly />
                                                </td>
                                            </tr>--}}
                                            <tr class="border-top border-top-dashed">
                                                <th scope="row">Total Amount</th>
                                                <td>
                                                    <input type="text" class="form-control grand_total bg-light border-0" id="cart-total" placeholder="UGX 0.00" readonly />
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!--end table-->
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <!--end table-->
                </div>
                <div class="row mt-3">
                    <div class="col-lg-4">
                        <div class="mb-2">
                            <label for="choices-payment-type" class="form-label text-muted text-uppercase fw-semibold">Payment Details</label>
                            <div class="input-light">
                                <select class="form-control payment_method" name="payment_method" required>
                                    <option value="" selected disabled>Payment Method</option>
                                    @foreach($payment_methods as $payment_method)
                                    <option value="{{ $payment_method->id }}" {{ (old("payment_method") == $payment_method->id) ? 'selected' : '' }}>
                                        {{ $payment_method->name }}
                                    </option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback">
                                    Please select a payment method
                                </div>
                            </div>
                        </div>
                        <div class="mb-2">
                            <input class="form-control bg-light border-0" type="text" name="sales_person" placeholder="Sales Person" value="{{ old('sales_person',\Auth::user()->name) }}">
                        </div>
                        {{-- <div class="mb-2">
                            <input class="form-control bg-light border-0" type="text" id="cardNumber" placeholder="xxxx xxxx xxxx xxxx">
                        </div>
                        <div>
                            <input class="form-control  bg-light border-0" type="text" id="amountTotalPay" placeholder="$0.00" readonly />
                        </div> --}}
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->
                <div class="mt-4">
                    <label for="exampleFormControlTextarea1" class="form-label text-muted text-uppercase fw-semibold">NOTES</label>
                    <textarea class="form-control alert alert-info ckeditor" id="exampleFormControlTextarea1" placeholder="Notes" rows="2" name="t_c">{!! $tcs !!}</textarea>
                </div>
                <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                    <button type="submit" class="btn btn-success" name="action" value="Completed"><i class="ri-printer-line align-bottom me-1"></i> Save Invoice</button>
                    <button type="submit" class="btn btn-primary" name="action" value="Draft"><i class="ri-download-2-line align-bottom me-1"></i> Save Draft Invoice</button>
                    
                    <div class="btn-group">
                        <button type="submit" name="action" class="btn btn-success" value="Save & Send">Save & Send</button>
                        <button type="button" class="btn btn-success dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button>
                        <div class="dropdown-menu">
                            <button type="submit" name="action" class="dropdown-item" value="Save & Download">Save & Download</button>
                            <button type="submit" name="action" class="dropdown-item" value="Save">Save</button>
                        </div>
                    </div><!-- /btn-group -->
                </div>
            </div>
        </form>
    </div>
</div>

@endsection
@section('customjs')
<script src="{{ asset('assets/js/jquery.repeater.min.js') }}"></script>
<script>
    $(document).ready(function () {
        $(".items").select2({
            placeholder: "Select Invoice Item",
        });

        $(".payment_method").select2()

        $(".customers").select2()

        var $repeater = $('.repeater').repeater({
            initEmpty: false,
            show: function () {
                $(this).slideDown();
                $('.select2-container').remove();
                $('.items, .customers, .payment_method').select2();
            },
            hide: function (deleteElement) {
                if(confirm('Are you sure you want to delete this element?')) {
                    $(this).slideUp(deleteElement);
                    $(this).remove();
                    subtotal()
                }
            },
            isFirstItemUndeletable: true
        });

        @if(old())
        $repeater.setList([
          @foreach (old('items') as $key => $invoice_item)
          {
              'item' :{{ $invoice_item['item'] }},
              'unit_price': {{ $invoice_item['unit_price'] }},
              'quantity': {{ $invoice_item['quantity'] }},
              'item_total': {{ $invoice_item['quantity'] * $invoice_item['unit_price'] }}
          },
          @endforeach
          ]);

        subtotal();
        @endif

        $(document).on("change",'.items',function(){
            var item_id = $(this).val();
            var el = $(this);

            $.ajax({
                url: "{{ url('item_details') }}/"+item_id,
                type: "GET",

                success: function(data){
                    $(el.parent().parent().parent().find('.unit_price')).val(data.selling_price);
                    $(el.parent().parent().parent().find('.quantity')).val(1);
                    $(el.parent().parent().parent().find('.item_total')).val(data.selling_price);
                    subtotal()
                }
            })
        });

        $(document).on("keyup",".unit_price,.quantity",function(){
            var el = $(this).parent().parent();

            var quantity=$(el.find(".quantity")).val(),unit_price=$(el.find(".unit_price")).val();
            console.log(unit_price+" "+quantity)
            $(el.find('.item_total')).val(quantity * unit_price);
            subtotal()
        })
    });

    function subtotal(){
        var inputs_quantity = $(".quantity");

        var priceInput = $('.unit_price');
        var subtotal = 0;
        for (var j = 0; j < priceInput.length; j++) {
         subtotal  += (parseFloat(priceInput[j].value) * parseFloat(inputs_quantity[j].value));
     }

     $(".grand_total").val((subtotal))
 }
</script>
@endsection