@extends('layouts.app')
@section('content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
        	<h5>Invoice Payments</h5>
            @can('create payments')
        	<button class="btn btn-primary" data-action="New" data-id="2323" data-title="Receive New Payment" ajax-load="true" data-url="{{ url('invoice_payments') }}"><i class="fa fa-plus"></i> Receive Payment</button>
            @endcan
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover dataTable">
            	<thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Balance</th>
                        <th role='columnheader'>Received By</th>
                    </tr>
                </thead>
                <tbody>
                	@foreach($payments as $payment)
                		<tr>
                			<td>{{ $payment?->invoice?->customer?->name }}</td>
                			<td>INV{{ sprintf("%05d",$payment?->invoice?->invoice_no) }}</td>
                			<td>{{ number_format($payment->amount) }}</td>
                			<td>{{ number_format($payment->balance) }}</td>
                			<td>{{ $payment->user->name }}</td>
                		</tr>
                	@endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection