@extends('layouts.app')

@section('content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Quotations</h5>

            @can('create quotations')
            <a href="{{ route('quotations.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Qoutation')</a>
            @endcan
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Issue Date</th>
                        <th role='columnheader'>Gross Amount</th>
                        <th role='columnheader'>Sales Person</th>
                        <th role='columnheader'>Status</th>
                        <th role='columnheader'>Created By</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($invoices as $invoice)
                    <tr>
                        <td data-label="Invoice No">INV{{ sprintf("%05d",$invoice->invoice_no) ?: "(blank)" }}</td>
                        <td data-label="Customer"><a href="{{implode('/', ['','customers',$invoice->customer_id ?: 0])}}" class="text-dark">{{$invoice?->customer?->name ?: "(blank)"}}</a></td>
                        <td data-label="Issue Date">{{ $invoice->issue_date ?: "(blank)" }}</td>
                        <td data-label="Gross Amount">{{ $invoice->gross_amount ?: "(blank)" }}</td>
                        <td data-label="Sales Person">{{ $invoice->sales_person ?: "(blank)" }}</td>
                        <td data-label="Status">{{ $invoice->status ?: "(blank)" }}</td>
                        <td data-label="Created By">{{ $invoice->user->name ?: "(blank)" }}</td>

                        <td data-label="Actions:" class="text-nowrap">
                         @if($invoice->trashed())
                         <form action="{{ route('invoices.restore', ['invoice' => $invoice]) }}" method="POST" class="d-inline-block me-2">
                            @csrf
                            @method('PUT')
                            <input type="submit" name="restore" value="@lang('Restore')" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="{{ route('invoices.purge', ['invoice' => $invoice]) }}" method="POST" class="d-inline-block">
                            @csrf
                            @method('DELETE')
                            <input type="submit" name="purge" value="@lang('Purge')" class="btn btn-danger btn-sm"/>
                        </form>
                        @else
                        <a href="{{url('quotations',$invoice->id)}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{route('invoices.edit', compact('invoice'))}}">@lang('Edit')</a></li>
                                <li>
                                    <form action="{{route('invoices.destroy', compact('invoice'))}}" method="POST" style="display: inline;" class="m-0 p-0">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="dropdown-item">@lang('Delete')</button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        @endif

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        {{-- {{ $invoices->withQueryString()->links() }} --}}
    </div>
    <div class="text-center my-2">
        
    </div>
</div>
</div>
@endsection
