@extends('suppliers.layout')

@section('suppliers.content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="{{ implode('/', ['','suppliers']) }}"> Suppliers</a></li>
                <li class="breadcrumb-item">@lang('Create new')</li>
            </ol>
        </div>

        <div class="card-body">
            <form action="{{ route('suppliers.store', []) }}" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    @csrf
                    <div class="mb-3">
                        <label for="name" class="form-label">Name:</label>
                        <input type="text" name="name" id="name" class="form-control" value="{{@old('name')}}" required/>
                        @if($errors->has('name'))
                        <div class='error small text-danger'>{{$errors->first('name')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="contacts" class="form-label">Contacts:</label>
                        <input type="text" name="contacts" id="contacts" class="form-control" value="{{@old('contacts')}}" />
                        @if($errors->has('contacts'))
                        <div class='error small text-danger'>{{$errors->first('contacts')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="address" class="form-label">Address:</label>
                        <input type="text" name="address" id="address" class="form-control" value="{{@old('address')}}" />
                        @if($errors->has('address'))
                        <div class='error small text-danger'>{{$errors->first('address')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="tin" class="form-label">Tin:</label>
                        <input type="text" name="tin" id="tin" class="form-control" value="{{@old('tin')}}" />
                        @if($errors->has('tin'))
                        <div class='error small text-danger'>{{$errors->first('tin')}}</div>
                        @endif
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="balance" class="form-label">Balance:</label>
                        <input type="text" name="balance" id="balance" class="form-control" value="{{@old('balance')}}" required/>
                        @if($errors->has('balance'))
                        <div class='error small text-danger'>{{$errors->first('balance')}}</div>
                        @endif
                    </div>

                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="{{ route('suppliers.index', []) }}" class="btn btn-light">@lang('Cancel')</a>
                        <button type="submit" class="btn btn-primary">@lang('Create new Supplier')</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
