<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\MonthlyFillingController;
use App\Http\Controllers\TaxController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\ExpenseItemController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\QuotationsController;
use App\Http\Controllers\InvoicePaymentsController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\PurchasePaymentController;
use App\Http\Controllers\TCsController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\AnalysisController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect('login');
});

Route::get('cron_job', [AnalysisController::class,'analysis']);

Route::get('/dashboard', [DashboardController::class,'main'])->middleware(['auth', 'verified','isActive'])->name('dashboard');

Route::middleware(['auth','isActive'])->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::get('accept_invitation/{token}', function($token){
    \Auth::logout();

    $invitation = \App\Models\Invitation::where('token',$token)->first();
    // $invitation->delete();

    return view('auth.register',compact('invitation'));
});

Route::middleware(['auth','isActive'])->group(function(){
    Route::resource('customers', CustomerController::class, []);
    Route::put('customers/{customer}/restore', [CustomerController::class, 'restore'])->name('customers.restore');
    Route::delete('customers/{customer}/purge', [CustomerController::class, 'purge'])->name('customers.purge');
    Route::resource('monthly_fillings', MonthlyFillingController::class, []);

    Route::resource('taxes', TaxController::class, []);
    //@softdelete
    Route::put('taxes/{tax}/restore', [TaxController::class, 'restore'])->name('taxes.restore');
    Route::delete('taxes/{tax}/purge', [TaxController::class, 'purge'])->name('taxes.purge');

    Route::resource('items', ItemController::class, []);
    //@softdelete
    Route::put('items/{item}/restore', [ItemController::class, 'restore'])->name('items.restore');
    Route::delete('items/{item}/purge', [ItemController::class, 'purge'])->name('items.purge');

     Route::resource('invoices', InvoiceController::class, []);

    Route::put('invoices/{invoice}/restore', [InvoiceController::class, 'restore'])->name('invoices.restore');
    Route::delete('invoices/{invoice}/purge', [InvoiceController::class, 'purge'])->name('invoices.purge');

    Route::get('item_details/{id}', [ItemController::class,'item_details']);

    Route::resource('payment_methods', PaymentMethodController::class, []);
    //@softdelete
    Route::put('payment_methods/{paymentMethod}/restore', [PaymentMethodController::class, 'restore'])->name('payment_methods.restore');
    Route::delete('payment_methods/{paymentMethod}/purge', [PaymentMethodController::class, 'purge'])->name('payment_methods.purge');
    //@endsoftdelete

    Route::resource('expense_items', ExpenseItemController::class, []);
    //@softdelete
    Route::put('expense_items/{expenseItem}/restore', [ExpenseItemController::class, 'restore'])->name('expense_items.restore');
    Route::delete('expense_items/{expenseItem}/purge', [ExpenseItemController::class, 'purge'])->name('expense_items.purge');

    Route::resource('expenses', ExpenseController::class, []);

    Route::resource('quotations', QuotationsController::class, []);

    Route::put('quotations/{invoice}/restore', [QuotationsController::class, 'restore'])->name('quotations.restore');
    Route::delete('quotations/{invoice}/purge', [QuotationsController::class, 'purge'])->name('quotations.purge');

    Route::get('download_quotation/{id}', [QuotationsController::class, 'download']);

    Route::resource('invoice_payments', InvoicePaymentsController::class);

    Route::resource('suppliers', SupplierController::class, []);
    //@softdelete
    Route::put('suppliers/{supplier}/restore', [SupplierController::class, 'restore'])->name('suppliers.restore');
    Route::delete('suppliers/{supplier}/purge', [SupplierController::class, 'purge'])->name('suppliers.purge');

    Route::resource('purchases', PurchaseController::class, []);
    //@softdelete
    Route::put('purchases/{purchase}/restore', [PurchaseController::class, 'restore'])->name('purchases.restore');
    Route::delete('purchases/{purchase}/purge', [PurchaseController::class, 'purge'])->name('purchases.purge');

    Route::resource('purchase_payments', PurchasePaymentController::class, []);
    //@softdelete
    Route::put('purchase_payments/{purchasePayment}/restore', [PurchasePaymentController::class, 'restore'])->name('purchase_payments.restore');
    Route::delete('purchase_payments/{purchasePayment}/purge', [PurchasePaymentController::class, 'purge'])->name('purchase_payments.purge');

    Route::get('send_invoice/{id}', [InvoiceController::class,'send_invoice_view']);
    Route::post('send_invoice',[InvoiceController::class,'send_invoice']);

    Route::resource('tcs', TCsController::class);

    Route::get('export_invoice/{type}/{id}', [InvoiceController::class,'export_invoice']);

    Route::get('invoices_report',[ReportsController::class,'invoices']);
    Route::get('pl_report',[ReportsController::class,'pl']);
    Route::get('incomes_report',[ReportsController::class,'incomes']);
    Route::get('expenses_report',[ReportsController::class,'expenses']);
    Route::get('purchases_report',[ReportsController::class,'purchases']);

    Route::get('users',[UsersController::class,'users']);
    Route::get('user_status/{user}/{status}',[UsersController::class,'status']);

    Route::POST('invite_user',[UsersController::class,'invite']);
    Route::get('user_permissions/{user}',[UsersController::class,'permissions']);
    Route::POST('assign_permission',[UsersController::class,'assign_permission']);

    Route::get('load_vat_files',[MonthlyFillingController::class,'loadVATFiles']);
    Route::post('load_vat_files',[MonthlyFillingController::class,'query_efris']);

    Route::post('ajax_upload', [MonthlyFillingController::class,'ajax_upload']);
    Route::post('analyze', [MonthlyFillingController::class,'analyze']);

    Route::resource('analysis', AnalysisController::class);

    Route::get('customer_ledgers', [ReportsController::class,'customers_ledgers']);
});

require __DIR__.'/auth.php';
