<?php $__env->startSection('expenses.content'); ?>
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','expenses'])); ?>"> Expenses</a></li>
                    <li class="breadcrumb-item"><?php echo app('translator')->get('Expense'); ?> #<?php echo e($expense->id); ?></li>
                </ol>

                <a href="<?php echo e(route('expenses.index', [])); ?>" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
            </div>

            <div class="card-body">
                <table class="table table-striped">
    <tbody>
    <tr>
        <th scope="row">ID:</th>
        <td><?php echo e($expense->id); ?></td>
    </tr>
            <tr>
            <th scope="row">Expense Item:</th>
            <td><a href="<?php echo e(implode('/', ['','expense_items',$expense->expense_item_id ?: 0])); ?>" class="text-dark"><?php echo e($expense?->expense_item?->name ?: "(blank)"); ?></a></td>
        </tr>
            <tr>
            <th scope="row">Payment Method:</th>
            <td><a href="<?php echo e(implode('/', ['','payment_methods',$expense->payment_method_id ?: 0])); ?>" class="text-dark"><?php echo e($expense?->payment_method?->name ?: "(blank)"); ?></a></td>
        </tr>
            <tr>
            <th scope="row">Expense Date:</th>
            <td><?php echo e($expense->expense_date ?: "(blank)"); ?></td>
        </tr>
            <tr>
            <th scope="row">Amount:</th>
            <td><?php echo e($expense->amount ?: "(blank)"); ?></td>
        </tr>
                <tr>
            <th scope="row">Created at</th>
            <td><?php echo e(Carbon\Carbon::parse($expense->created_at)->format('d/m/Y H:i:s')); ?></td>
        </tr>
        <tr>
            <th scope="row">Updated at</th>
            <td><?php echo e(Carbon\Carbon::parse($expense->updated_at)->format('d/m/Y H:i:s')); ?></td>
        </tr>
        </tbody>
</table>

            </div>

            <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
                <a href="<?php echo e(route('expenses.edit', compact('expense'))); ?>" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
                <form action="<?php echo e(route('expenses.destroy', compact('expense'))); ?>" method="POST" class="m-0 p-0">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('expenses.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/expenses/show.blade.php ENDPATH**/ ?>