<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Quotations</h5>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create quotations')): ?>
            <a href="<?php echo e(route('quotations.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Qoutation'); ?></a>
            <?php endif; ?>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Issue Date</th>
                        <th role='columnheader'>Gross Amount</th>
                        <th role='columnheader'>Sales Person</th>
                        <th role='columnheader'>Status</th>
                        <th role='columnheader'>Created By</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Invoice No">INV<?php echo e(sprintf("%05d",$invoice->invoice_no) ?: "(blank)"); ?></td>
                        <td data-label="Customer"><a href="<?php echo e(implode('/', ['','customers',$invoice->customer_id ?: 0])); ?>" class="text-dark"><?php echo e($invoice?->customer?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Issue Date"><?php echo e($invoice->issue_date ?: "(blank)"); ?></td>
                        <td data-label="Gross Amount"><?php echo e($invoice->gross_amount ?: "(blank)"); ?></td>
                        <td data-label="Sales Person"><?php echo e($invoice->sales_person ?: "(blank)"); ?></td>
                        <td data-label="Status"><?php echo e($invoice->status ?: "(blank)"); ?></td>
                        <td data-label="Created By"><?php echo e($invoice->user->name ?: "(blank)"); ?></td>

                        <td data-label="Actions:" class="text-nowrap">
                         <?php if($invoice->trashed()): ?>
                         <form action="<?php echo e(route('invoices.restore', ['invoice' => $invoice])); ?>" method="POST" class="d-inline-block me-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="<?php echo e(route('invoices.purge', ['invoice' => $invoice])); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
                        </form>
                        <?php else: ?>
                        <a href="<?php echo e(url('quotations',$invoice->id)); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('invoices.edit', compact('invoice'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
                                <li>
                                    <form action="<?php echo e(route('invoices.destroy', compact('invoice'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        
    </div>
    <div class="text-center my-2">
        
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/sales/quotations/index.blade.php ENDPATH**/ ?>