<?php $__env->startSection('purchasePayments.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Purchase Payment</h5>

            <a href="<?php echo e(route('purchase_payments.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create New Purchase Payment'); ?></a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Purchase</th>
                        <th role='columnheader'>Payment Method</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Balance</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $purchasePayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchasePayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Purchase"><a href="<?php echo e(implode('/', ['','purchases',$purchasePayment->purchase_id ?: 0])); ?>" class="text-dark"><?php echo e($purchasePayment?->purchase?->item?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Payment Method"><a href="<?php echo e(implode('/', ['','payment_methods',$purchasePayment->payment_method_id ?: 0])); ?>" class="text-dark"><?php echo e($purchasePayment?->payment_method?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Amount"><?php echo e($purchasePayment->amount ?: "(blank)"); ?></td>
                        <td data-label="Balance"><?php echo e($purchasePayment->balance ?: "0"); ?></td>

                        <td data-label="Actions:" class="text-nowrap">
                         <?php if($purchasePayment->trashed()): ?>
                         <form action="<?php echo e(route('purchase_payments.restore', ['purchasePayment' => $purchasePayment])); ?>" method="POST" class="d-inline-block me-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="<?php echo e(route('purchase_payments.purge', ['purchasePayment' => $purchasePayment])); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
                        </form>
                        <?php else: ?>
                       

                        <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        
    </div>
    <div class="text-center my-2">
        
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('purchase_payments.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/purchase_payments/index.blade.php ENDPATH**/ ?>