<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
                <ol class="breadcrumb m-0 p-0 flex-grow-1 mb-2 mb-md-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','taxes'])); ?>"> Taxes</a></li>
                </ol>

                <form action="<?php echo e(route('taxes.index', [])); ?>" method="GET" class="m-0 p-0">
                    <div class="input-group">
                        <input type="text" class="form-control form-control-sm me-2" name="search" placeholder="Search Taxes..." value="<?php echo e(request()->search); ?>">
                        <span class="input-group-btn">
                            <button class="btn btn-info btn-sm" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('Go!'); ?></button>
                        </span>
                    </div>
                </form>
            </div>
            <div class="card-body">
                <table class="table table-striped table-responsive table-hover">
    <thead role="rowgroup">
    <tr role="row">
                    <th role='columnheader'>Name</th>
                <th scope="col" data-label="Actions">Actions</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
                            <td data-label="Name"><?php echo e($tax->name ?: "(blank)"); ?></td>

            <td data-label="Actions:" class="text-nowrap">
                                   <?php if($tax->trashed()): ?>
    <form action="<?php echo e(route('taxes.restore', ['tax' => $tax])); ?>" method="POST" class="d-inline-block me-2">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
    </form>
    <form action="<?php echo e(route('taxes.purge', ['tax' => $tax])); ?>" method="POST" class="d-inline-block">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
    </form>
<?php else: ?>
    <a href="<?php echo e(route('taxes.show', compact('tax'))); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
<div class="btn-group btn-group-sm">
    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
    <ul class="dropdown-menu">
        <li><a class="dropdown-item" href="<?php echo e(route('taxes.edit', compact('tax'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
        <li>
            <form action="<?php echo e(route('taxes.destroy', compact('tax'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
            </form>
        </li>
    </ul>
</div>

<?php endif; ?>

                            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

                <?php echo e($taxes->withQueryString()->links()); ?>

            </div>
            <div class="text-center my-2">
                <a href="<?php echo e(route('taxes.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Tax'); ?></a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/taxes/index.blade.php ENDPATH**/ ?>