<?php $__env->startSection('items.content'); ?>
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','items'])); ?>"> Items</a></li>
                    <li class="breadcrumb-item"><?php echo app('translator')->get('Create new'); ?></li>
                </ol>
            </div>

            <div class="card-body">
                <form action="<?php echo e(route('items.store', [])); ?>" method="POST" class="m-0 p-0">
                    <div class="card-body">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
        <label for="sku" class="form-label">Sku:</label>
        <input type="text" name="sku" id="sku" class="form-control" value="<?php echo e(@old('sku')); ?>" />
        <?php if($errors->has('sku')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('sku')); ?></div>
		<?php endif; ?>
    </div>
    <div class="mb-3">
        <label for="name" class="form-label">Name:</label>
        <input type="text" name="name" id="name" class="form-control" value="<?php echo e(@old('name')); ?>" required/>
        <?php if($errors->has('name')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('name')); ?></div>
		<?php endif; ?>
    </div>
    <div class="mb-3">
        <label for="type" class="form-label">Type:</label>
        <select name="type" id="type" class="form-control form-select" required>
    <option value="" selected disabled>Select Type</option>
    <?php $__currentLoopData = ["Product" => "Product", "Service" => "Service"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($value); ?>" <?php echo e(@old('type') == $value ? "selected" : ""); ?>><?php echo e($label); ?></option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
        <?php if($errors->has('type')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('type')); ?></div>
		<?php endif; ?>
    </div>
    <div class="mb-3">
        <label for="cost_price" class="form-label">Cost Price:</label>
        <input type="number" name="cost_price" id="cost_price" class="form-control" value="<?php echo e(@old('cost_price')); ?>" required/>
        <?php if($errors->has('cost_price')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('cost_price')); ?></div>
		<?php endif; ?>
    </div>
    <div class="mb-3">
        <label for="selling_price" class="form-label">Selling Price:</label>
        <input type="number" name="selling_price" id="selling_price" class="form-control" value="<?php echo e(@old('selling_price')); ?>" required/>
        <?php if($errors->has('selling_price')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('selling_price')); ?></div>
		<?php endif; ?>
    </div>
    <div class="mb-3">
        <label for="stock" class="form-label">Stock:</label>
        <input type="number" name="stock" id="stock" class="form-control" value="<?php echo e(@old('stock')); ?>" required/>
        <?php if($errors->has('stock')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('stock')); ?></div>
		<?php endif; ?>
    </div>

                    </div>

                    <div class="card-footer">
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <a href="<?php echo e(route('items.index', [])); ?>" class="btn btn-light"><?php echo app('translator')->get('Cancel'); ?></a>
                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Create new Item'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('items.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/items/create.blade.php ENDPATH**/ ?>