<?php $__env->startSection('purchases.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','purchases'])); ?>"> Purchases</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Create new'); ?></li>
            </ol>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('purchases.store', [])); ?>" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="supplier_id" class="form-label">Supplier:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="supplier_id" id="supplier_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Supplier</option>
                                <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($supplier->id); ?>" <?php echo e(@old('supplier_id') == $supplier->id ? "selected" : ""); ?>><?php echo e($supplier->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <a class="btn btn-light text-nowrap" href="<?php echo e(implode('/', ['','suppliers','create'])); ?>"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        <?php if($errors->has('supplier_id')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('supplier_id')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="items_id" class="form-label">Item:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="items_id" id="items_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Item</option>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>" <?php echo e(@old('items_id') == $item->id ? "selected" : ""); ?>><?php echo e("(".$item->sku.") - ".$item->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <a class="btn btn-light text-nowrap" href="<?php echo e(implode('/', ['','items','create'])); ?>"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        <?php if($errors->has('items_id')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('items_id')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="payment_method_id" class="form-label">Payment Method:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="payment_method_id" id="payment_method_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Payment Method</option>
                                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($paymentMethod->id); ?>" <?php echo e(@old('payment_method_id') == $paymentMethod->id ? "selected" : ""); ?>><?php echo e($paymentMethod->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <a class="btn btn-light text-nowrap" href="<?php echo e(implode('/', ['','paymentMethods','create'])); ?>"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        <?php if($errors->has('payment_method_id')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('payment_method_id')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3">
                        <label for="amount" class="form-label">Amount:</label>
                        <input type="text" name="amount" id="amount" class="form-control" value="<?php echo e(@old('amount')); ?>" required/>
                        <?php if($errors->has('amount')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('amount')); ?></div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="<?php echo e(route('purchases.index', [])); ?>" class="btn btn-light"><?php echo app('translator')->get('Cancel'); ?></a>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Create new Purchase'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('purchases.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/purchases/create.blade.php ENDPATH**/ ?>