<?php $__env->startSection('expenseItems.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','expense_items'])); ?>"> Expense Items</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Edit Expense Item'); ?> #<?php echo e($expenseItem->id); ?></li>
            </ol>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('expense_items.update', $expenseItem->id)); ?>" method="POST" class="m-0 p-0">
                <?php echo method_field('PUT'); ?>
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="name" class="form-label">Name:</label>
                        <input type="text" name="name" id="name" class="form-control" value="<?php echo e(@old('name', $expenseItem->name)); ?>" required/>
                        <?php if($errors->has('name')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('name')); ?></div>
                        <?php endif; ?>
                    </div>

                </div>
                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="<?php echo e(route('expense_items.index', [])); ?>" class="btn btn-light">Cancel</a>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Update Expense Item'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('expense_items.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/expense_items/edit.blade.php ENDPATH**/ ?>