<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style>
		.text-center{
			text-align: center;
		}

		.text-left{
			text-align: left;
		}

		.bold{
			font-weight: bold;
		}

		.heading{
			margin: 20px;
		}
		table{
			border-collapse: collapse;
		}
		thead{
			color: white;
			background: black;
			border-collapse: collapse;
		}
		tr:nth-child(even) {
			background-color: #f2f2f2;
		}
	</style>
</head>
<body>
	<div class="heading">
		<div class="text-center">
			<div class="bold">WYKA CONSULTING GROUP</div>
			<div>Addres: Arua Park Plaza</div>
			<div>Email: finance@wykaconsults.com</div>
			<div>Website: wykaconsults.com</div>
			<div>Tel: +256 784 326279</div>
		</div>
	</div>
	<div class="text-center">
		<div class="bold">Profit & Loss Report</div>
		<div>
			From <?php echo e(date('M d, Y',strtotime($request->start_date)).' To '.date('M d, Y',strtotime($request->end_date))); ?>

		</div>
	</div>
	<div class="heading">
		<table style="width:100%">
				<thead>
					<th class="text-left">Item</th>
					<th class="text-end">Amount</th>
				</thead>
				<tr>
					<td>
						Sales
					</td>
					<td class="text-end">
						<?php echo e(number_format($summary->sales)); ?>

					</td>
				</tr>
				<tr>
					<td>
						Purchases
					</td>
					<td class="text-end">
						<?php echo e(number_format($summary->purchases)); ?>

					</td>
				</tr>
				<thead>
					<th>
						Gross Profit / Loss
					</th>
					<th class="text-end">
						<?php echo e(number_format($summary->sales - $summary->purchases)); ?>

					</th>
				</thead>
				<tr>
					<td>
						Expenses
					</td>
					<td class="text-end">
						<?php echo e(number_format($summary->expenses)); ?>

					</td>
				</tr>
				<thead>
					<th>
						Net Profit / Loss
					</th>
					<th class="text-end">
						<?php echo e(number_format(($summary->sales - $summary->purchases) - $summary->expenses)); ?>

					</th>
				</thead>
			</table>
	</div>
</body>
</html><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/reports/pdfs/pl.blade.php ENDPATH**/ ?>