<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Customers</h5>

            <a href="<?php echo e(route('customers.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Customer'); ?></a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Name</th>
                        <th role='columnheader'>Address</th>
                        <th role='columnheader'>Email</th>
                        <th role='columnheader'>Phone No</th>
                        <th role='columnheader'>Tin</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Name"><?php echo e($customer->name ?: "(blank)"); ?></td>
                        <td data-label="Address"><?php echo e($customer->address ?: "(blank)"); ?></td>
                        <td data-label="Email"><?php echo e($customer->email ?: "(blank)"); ?></td>
                        <td data-label="Phone No"><?php echo e($customer->phone_no ?: "(blank)"); ?></td>
                        <td data-label="Tin"><?php echo e($customer->tin ?: "(blank)"); ?></td>

                        <td data-label="Actions:" class="text-nowrap">
                           <?php if($customer->trashed()): ?>
                           <form action="<?php echo e(route('customers.restore', ['customer' => $customer])); ?>" method="POST" class="d-inline-block me-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="<?php echo e(route('customers.purge', ['customer' => $customer])); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
                        </form>
                        <?php else: ?>
                        <a href="<?php echo e(route('customers.show', compact('customer'))); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('customers.edit', compact('customer'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
                                <li>
                                    <form action="<?php echo e(route('customers.destroy', compact('customer'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/customers/index.blade.php ENDPATH**/ ?>