<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Monthly Fillings</h5>
            <a href="<?php echo e(route('monthly_fillings.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Monthly Filling'); ?></a>
        </div>

        <!-- Filters Section -->
        <div class="card-body">
            <div class="row mb-3">
                <!-- Customer Filter -->
                <div class="col-md-4">
                    <label for="filterCustomer" class="form-label">Filter by Customer:</label>
                    <select id="filterCustomer" class="form-control select2">
                        <option value="">All</option>
                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($customer->name); ?>"><?php echo e($customer->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Month Filter Dropdown -->
                <div class="col-md-4">
                    <label for="filterMonth" class="form-label">Filter by Month:</label>
                    <select id="filterMonth" class="form-control">
                        <option value="">All</option>
                        <option value="Jan">January</option>
                        <option value="Feb">February</option>
                        <option value="Mar">March</option>
                        <option value="Apr">April</option>
                        <option value="May">May</option>
                        <option value="Jun">June</option>
                        <option value="Jul">July</option>
                        <option value="Aug">August</option>
                        <option value="Sep">September</option>
                        <option value="Oct">October</option>
                        <option value="Nov">November</option>
                        <option value="Dec">December</option>
                    </select>
                </div>

                <!-- Year Filter Dropdown -->
                <div class="col-md-4">
                    <label for="filterYear" class="form-label">Filter by Year:</label>
                    <select id="filterYear" class="form-control">
                        <option value="">All</option>
                        <option value="2022">2022</option>
                        <option value="2022">2023</option>
                        <option value="2022">2024</option>
                        <option value="2022">2025</option>
                    </select>
                </div>
            </div>

            <!-- DataTable -->
            <table class="table table-striped table-responsive table-hover dataTable" id="monthlyFillingTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Month</th>
                        <th role='columnheader'>Purchases</th>
                        <th role='columnheader'>Sales</th>
                        <th role='columnheader'>Resultant VAT</th>
                        <th role='columnheader'>User</th>
                        <th role="columnheader">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $monthlyFillings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monthlyFilling): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Customer">
                            <a href="<?php echo e(url('customers/'.$monthlyFilling->customer_id ?: 0)); ?>" class="text-dark">
                                <?php echo e($monthlyFilling?->customer?->name ?: "(blank)"); ?></a>
                        </td>
                        <td data-label="Month"><?php echo e(date('M-Y', strtotime($monthlyFilling->month)) ?: "0"); ?></td>
                        <td data-label="Purchases"><?php echo e(number_format($monthlyFilling->purchases) ?: "0"); ?></td>
                        <td data-label="Gross Sales"><?php echo e(number_format($monthlyFilling->gross_sales) ?: "0"); ?></td>
                        <td data-label="VAT"><?php echo e(number_format($monthlyFilling->output_vat) ?: "0"); ?></td>
                        <td data-label="User"><?php echo e($monthlyFilling->user->name); ?></td>
                        <td data-label="Actions" class="text-nowrap">
                            <a href="<?php echo e(url('monthly_fillings/'.$monthlyFilling->id)); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
                            <div class="btn-group btn-group-sm">
                                <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="<?php echo e(route('monthly_fillings.edit', $monthlyFilling->id)); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
                                    <li>
                                        <form action="<?php echo e(route('monthly_fillings.destroy', $monthlyFilling->id)); ?>" method="POST" style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    // Initialize DataTable
    var table = $('#monthlyFillingTable').DataTable({
        "dom": 't<"d-flex justify-content-between"<"i"l><"p"p>>',
        "pageLength": 10,
    });

    // Filter Customer
    $('#filterCustomer').on('change', function () {
        table.column(0).search($(this).val()).draw();
    });

    // Filter Month
    $('#filterMonth').on('change', function () {
        let selectedMonth = $(this).val();
        if (selectedMonth) {
            table.column(1).search(selectedMonth).draw();
        } else {
            table.column(1).search('').draw();
        }
    });

    // Filter Year
    $('#filterYear').on('change', function () {
        let selectedYear = $(this).val();
        if (selectedYear) {
            table.column(1).search(selectedYear).draw();
        } else {
            table.column(1).search('').draw();
        }
    });

    // Combine Month and Year Filters
    $('#filterMonth, #filterYear').on('change', function () {
        let selectedMonth = $('#filterMonth').val();
        let selectedYear = $('#filterYear').val();
        let searchValue = '';

        if (selectedMonth && selectedYear) {
            searchValue = selectedMonth + '-' + selectedYear;
        } else if (selectedMonth) {
            searchValue = selectedMonth;
        } else if (selectedYear) {
            searchValue = selectedYear;
        }

        table.column(1).search(searchValue).draw();
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/monthly_fillings/index.blade.php ENDPATH**/ ?>