
<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
        	<h5>Invoice Payments</h5>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create payments')): ?>
        	<button class="btn btn-primary" data-action="New" data-id="2323" data-title="Receive New Payment" ajax-load="true" data-url="<?php echo e(url('invoice_payments')); ?>"><i class="fa fa-plus"></i> Receive Payment</button>
            <?php endif; ?>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover dataTable">
            	<thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Balance</th>
                        <th role='columnheader'>Received By</th>
                    </tr>
                </thead>
                <tbody>
                	<?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                		<tr>
                			<td><?php echo e($payment?->invoice?->customer?->name); ?></td>
                			<td>INV<?php echo e(sprintf("%05d",$payment?->invoice?->invoice_no)); ?></td>
                			<td><?php echo e(number_format($payment->amount)); ?></td>
                			<td><?php echo e(number_format($payment->balance)); ?></td>
                			<td><?php echo e($payment->user->name); ?></td>
                		</tr>
                	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/sales/payments/index.blade.php ENDPATH**/ ?>