<?php $__env->startSection('content'); ?>
<div class="card">
	<div class="card-body">
		<form class="row">
			<div class="col-md-3">
				<label>Start Date</label>
				<input type="date" name="start_date" class="form-control" value="<?php echo e(($request->start_date) ? $request->start_date : date('Y-m-d')); ?>" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>End Date</label>
				<input type="date" name="end_date" class="form-control" value="<?php echo e(($request->end_date) ? $request->end_date : date('Y-m-d')); ?>" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>User</label>
				<select class="form-select select2" name="user[]" multiple>
					<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($user->id); ?>" <?php echo e(($request->user) ? (in_array($user->id,$request->user) ? 'selected':''):''); ?>><?php echo e($user->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
			<div class="col-md-3">
				<label></label>
				<button type="submit" class="btn btn-primary">Search</button>
				<button type="submit" class="btn btn-warning" name="download" value="pdf">PDF</button>
			</div>
		</form>
	</div>
</div>
<div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Invoices</h5>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover table-bordered dataTable">
                <thead role="rowgroup bg-light">
                    <tr role="row">
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Issue Date</th>
                        <th role='columnheader'>Gross Amount</th>
                        <th role='columnheader'>Sales Person</th>
                        <th role='columnheader'>Status</th>
                        <th role='columnheader'>Created By</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Invoice No">INV<?php echo e(sprintf("%05d",$invoice->invoice_no) ?: "(blank)"); ?></td>
                        <td data-label="Customer"><a href="<?php echo e(implode('/', ['','customers',$invoice->customer_id ?: 0])); ?>" class="text-dark"><?php echo e($invoice?->customer?->name ?: "(blank)"); ?></a></td>
                        <td data-label="Issue Date"><?php echo e($invoice->issue_date ?: "(blank)"); ?></td>
                        <td data-label="Gross Amount"><?php echo e(number_format($invoice->gross_amount) ?: "(blank)"); ?></td>
                        <td data-label="Sales Person"><?php echo e($invoice->sales_person ?: "(blank)"); ?></td>
                        <td data-label="Status">
                            <span class="badge <?php echo e(($invoice->status == "Completed") ? "bg-primary" : "bg-warning"); ?>"><?php echo e($invoice->status ?: "(blank)"); ?></span>
                        </td>
                        <td data-label="Created By"><?php echo e($invoice->user->name ?: "(blank)"); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/reports/invoices.blade.php ENDPATH**/ ?>