<?php $__env->startSection('purchasePayments.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','purchase_payments'])); ?>"> Purchase Payments</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Create new'); ?></li>
            </ol>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('purchase_payments.store', [])); ?>" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3 col-md-6">
                        <label for="purchase_id" class="form-label">Purchase:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="purchase_id" id="purchase_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Purchase</option>
                                <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($purchase->id); ?>" <?php echo e(@old('purchase_id') == $purchase->id ? "selected" : ""); ?>><?php echo e($purchase->supplier->name.' - '.number_format($purchase->amount)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <a class="btn btn-light text-nowrap" href="<?php echo e(implode('/', ['','purchases','create'])); ?>"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        <?php if($errors->has('purchase_id')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('purchase_id')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="payment_method_id" class="form-label">Payment Method:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="payment_method_id" id="payment_method_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Payment Method</option>
                                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($paymentMethod->id); ?>" <?php echo e(@old('payment_method_id') == $paymentMethod->id ? "selected" : ""); ?>><?php echo e($paymentMethod->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <a class="btn btn-light text-nowrap" href="<?php echo e(implode('/', ['','paymentMethods','create'])); ?>"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        <?php if($errors->has('payment_method_id')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('payment_method_id')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3">
                        <label for="amount" class="form-label">Amount:</label>
                        <input type="text" name="amount" id="amount" class="form-control number_format" value="<?php echo e(@old('amount')); ?>" required/>
                        <?php if($errors->has('amount')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('amount')); ?></div>
                        <?php endif; ?>
                    </div>
                    

                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="<?php echo e(route('purchase_payments.index', [])); ?>" class="btn btn-light"><?php echo app('translator')->get('Cancel'); ?></a>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Create new Purchase Payment'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('purchase_payments.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/purchase_payments/create.blade.php ENDPATH**/ ?>