<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title></title>
    <style type="text/css">
        .text-left{
            text-align: left;
        }

        .text-center{
            text-align: center;
        }
        .text-right{
            text-align:right;
        }
        .bold{
            font-weight: bold;
        }

        body{
            font-family: "poppins";
            font-size: 14px;
        }

        table{
            border-collapse: collapse;
        }

        thead{
            color: white;
            background: black;
            border-collapse: collapse;
        }
        tr:nth-child(even) {
                background-color: #f2f2f2;
            }
    </style>
</head>
<body>
<table style="width:100%; table-layout: fixed; overflow-wrap: break-word;">
    <tr>
        <td colspan="2">
            <img src="<?php echo e(asset('assets/images/logo.jpeg')); ?>" style="height: 100px;">
        </td>
        <td>
            <div class="bold">WYKA CONSULTING GROUP</div>
            <div>Addres: Mukwano Courts - Buganda Road, 201-202 K2</div>
            <div>Email: finance@wykaconsults.com</div>
            <div>Website: wykaconsults.com</div>
            <div>Tel: +256 784 326279</div>
        </td>
    </tr>
</table>
<table style="width:100%; table-layout: fixed; overflow-wrap: break-word; margin-top: 10px;">
    <tr>
        <td colspan="2">
            <div class="bold"><?php echo e($invoice->customer->name); ?></div>
            <div><?php echo e($invoice->customer->address); ?></div>
            <div><?php echo e($invoice->customer->phone_no); ?></div>
        </td>
        <td>
            <div>Quotation No: <span class="bold"><?php echo e(sprintf("%05d",$invoice->invoice_no)); ?></span></div>
            <div>Issue Date: <span class="bold"><?php echo e(date('M d, Y',strtotime($invoice->issue_date))); ?></span></div>
            <div>Expiry Date: <span class="bold"><?php echo e(date('M d, Y',strtotime($invoice->due_date))); ?></span></div>
        </td>
    </tr>
</table>
<table style="width:100%; table-layout: fixed; overflow-wrap: break-word; margin-top: 10px;">
    <thead>
        <th style="width: 40%;" class="text-left">Item Name</th>
        <th class="text-center">Unit Price</th>
        <th class="text-center">Quantity</th>
        <th>Total</th>
    </thead>
    <tbody>
        <?php $__currentLoopData = $invoice->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="items">
                <td><?php echo e($invoice_item->item->name); ?>

                <div style="margin-left:20px;"><?php echo e($invoice_item->description); ?></div>
                </td>
                <td class="text-center"><?php echo e(number_format($invoice_item->unit_price,2)); ?></td>
                <td class="text-center"><?php echo e(number_format($invoice_item->quantity,2)); ?></td>
                <td class="text-center"><?php echo e(number_format($invoice_item->unit_price * $invoice_item->quantity,2)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td colspan="3" class="bold text-right">Net Amount</td>
            <td class="text-center"><?php echo e(number_format($invoice->net_amount,2)); ?></td>
        </tr>
        <tr>
            <td colspan="3" class="bold text-right">VAT</td>
            <td class="text-center"><?php echo e(number_format($invoice->vat,2)); ?></td>
        </tr>
        <tr>
            <td colspan="3" class="bold text-right">Gross Amount</td>
            <td class="text-center"><?php echo e(number_format( $invoice->gross_amount,2)); ?></td>
        </tr>
        <!-- <tr>
            <td colspan="3" class="bold text-right">Paid Amount</td>
            <td class="text-center"><?php echo e(number_format($invoice->paid,2)); ?></td>
        </tr>
        <tr>
            <td colspan="3" class="bold text-right">Balance</td>
            <td class="text-center"><?php echo e(number_format($invoice->balance,2)); ?></td>
        </tr> -->
    </tbody>
</table>
<div><?php echo $invoice->t_c; ?></div>
</body>
</html><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/sales/quotations/templates/1.blade.php ENDPATH**/ ?>