<?php $__env->startSection('content'); ?>

<div class="row justify-content-center">
    <div class="col-xxl-9">
        <div class="card" id="demo">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card-header border-bottom-dashed p-4">
                        <div class="d-flex">
                            <div class="flex-grow-1">
                                <h5 style="font-size: 30px; ">INVOICE</h5>
                                <div class="mt-sm-4 mt-3">
                                    <h6 class="text-muted text-uppercase fw-semibold"><?php echo e($invoice->customer->name); ?></h6>
                                    <p class="text-muted mb-1" id="address-details">
                                        <?php echo e($invoice->customer->address); ?>

                                    </p>
                                    <p class="text-muted mb-0" id="zip-code">
                                        <?php echo e($invoice->customer->phone_no); ?>

                                    </p>
                                </div>
                            </div>
                            <div class="flex-shrink-0 mt-sm-0 mt-3">
                                <h6><span id="legal-register-no"><?php echo e(env('BUSINESS_NAME')); ?></span></h6>
                                <h6><span class="text-muted fw-normal">Email:</span><span id="email">
                                    <?php echo e(env('BUSINESS_EMAIL')); ?>

                                </span></h6>
                                <h6><span class="text-muted fw-normal">Website:</span> <a href="<?php echo e(env('BUSINESS_WEBSITE')); ?>" class="link-primary" target="_blank" id="website"><?php echo e(env('BUSINESS_WEBSITE')); ?></a></h6>
                                <h6 class="mb-0"><span class="text-muted fw-normal">Contact No: </span><span id="contact-no"> <?php echo e(env('BUSINESS_CONTACT')); ?></span></h6>
                            </div>
                        </div>
                    </div>
                    <!--end card-header-->
                </div><!--end col-->
                <div class="col-lg-12">
                    <div class="card-body p-4">
                        <div class="row g-3">
                            <div class="col-lg-6 col-6">
                                <p class="text-muted mb-2 text-uppercase fw-semibold">Invoice No</p>
                                <h5 class="fs-14 mb-0">#INV<span id="invoice-no"><?php echo e(sprintf('%05d',$invoice->invoice_no)); ?></span></h5>
                            </div>
                            <!--end col-->
                            <div class="col-lg-6 col-6">
                                <p class="text-muted mb-2 text-uppercase fw-semibold">Date</p>
                                <h5 class="fs-14 mb-0"><span id="invoice-date"><?php echo e(date("d M, Y",strtotime($invoice->created_at))); ?></span> <small class="text-muted" id="invoice-time"><?php echo e(date("h:i A",strtotime($invoice->created_at))); ?></small></h5>
                            </div>
                            <!--end col-->
                            
                            <!--end col-->
                            
                            <!--end col-->
                        </div>
                        <!--end row-->
                    </div>
                    <!--end card-body-->
                </div><!--end col-->
                
                <div class="col-lg-12">
                    <div class="card-body p-4">
                        <div class="table-responsive">
                            <table class="table table-borderless text-center table-nowrap align-middle mb-0">
                                <thead>
                                    <tr class="table-active">
                                        <th scope="col">Product Details</th>
                                        <th scope="col">Rate</th>
                                        <th scope="col">Quantity</th>
                                        <th scope="col" class="text-end">Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="products-list">
                                    <?php $__currentLoopData = $invoice->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-start">
                                                <span class="fw-medium"><?php echo e($invoice_item->item->name); ?></span>
                                                <p class="text-muted mb-0"><?php echo e($invoice_item->description); ?></p>
                                            </td>
                                            <td><?php echo e($invoice_item->unit_price); ?></td>
                                            <td><?php echo e($invoice_item->quantity); ?></td>
                                            <td class="text-end"><?php echo e($invoice_item->total); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table><!--end table-->
                        </div>
                        <div class="border-top border-top-dashed mt-2">
                            <table class="table table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:250px">
                                <tbody>
                                    <tr>
                                        <td>Sub Total</td>
                                        <td class="text-end"><?php echo e($invoice->gross_amount); ?></td>
                                    </tr>
                                    
                                    <tr class="border-top border-top-dashed fs-15">
                                        <th scope="row">Total Amount</th>
                                        <th class="text-end"><?php echo e($invoice->gross_amount); ?></th>
                                    </tr>
                                   
                                </tbody>
                            </table>
                            <!--end table-->
                        </div>
                       
                        <div class="mt-4">
                            <div class="alert alert-info">
                                <p class="mb-0"><span class="fw-semibold">NOTES:</span>
                                    <?php echo $invoice->t_c; ?>

                                </p>
                            </div>
                        </div>
                        <div class="hstack gap-2 justify-content-end d-print-none mt-4">
                            <a href="javascript:window.print()" class="btn btn-success"><i class="ri-printer-line align-bottom me-1"></i> Print</a>
                            <a href="<?php echo e(url('download_quotation/'.$invoice->id)); ?>" class="btn btn-primary"><i class="ri-download-2-line align-bottom me-1"></i> Download</a>
                        </div>
                    </div>
                    <!--end card-body-->
                </div><!--end col-->
            </div><!--end row-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/sales/quotations/show.blade.php ENDPATH**/ ?>