<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style>
		.text-center{
			text-align: center;
		}

		.text-left{
			text-align: left;
		}

		.bold{
			font-weight: bold;
		}

		.heading{
			margin: 20px;
		}
		table{
			border-collapse: collapse;
		}
		thead{
			color: white;
			background: black;
			border-collapse: collapse;
		}
		.item:nth-child(even) {
			background-color: #f2f2f2;
		}
	</style>
</head>
<body>
	<div class="heading">
		<div class="text-center">
			<div class="bold">WYKA CONSULTING GROUP</div>
			<div>Addres: Arua Park Plaza</div>
			<div>Email: finance@wykaconsults.com</div>
			<div>Website: wykaconsults.com</div>
			<div>Tel: +256 784 326279</div>
		</div>
	</div>
	<div class="text-center">
		<div class="bold">Incomes Report</div>
		<div>
			From <?php echo e(date('M d, Y',strtotime($request->start_date)).' To '.date('M d, Y',strtotime($request->end_date))); ?>

		</div>
	</div>
	<div class="heading">
		<table style="width: 100%;">
			<thead>
			<th role='columnheader'>Date</th>
                        <th role='columnheader'>Customer</th>
                        <th role='columnheader'>Invoice No</th>
                        <th role='columnheader'>Amount</th>
                        <th role='columnheader'>Received By</th>
			</thead>
			<tbody>
				<?php
				$total = 0;
				?>
				<?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<?php
				$total += $payment->amount;
				?>
				<tr class="item">
				<td><?php echo e(date('d M, Y',strtotime($payment->created_at))); ?></td>
                        <td data-label="Customer"><?php echo e($payment?->invoice?->customer?->name ?: "(blank)"); ?></td>
                        <td data-label="Invoice No">INV<?php echo e(sprintf("%05d",$payment->invoice->invoice_no) ?: "(blank)"); ?></td>
                        <td data-label="Gross Amount"><?php echo e(number_format($payment->amount) ?: "0"); ?></td>
                        <td data-label="Sales Person"><?php echo e($payment->user->name ?: "(blank)"); ?></td>
				</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		</table>
	</div>
	<div class="heading">
		<table width="100%">
			<tr>
				<td width="60%"></td>
				<td>

					<div style="background: #fffafa; border-radius: 7px; padding:10px">
						<table style="width:100%;">
						<tr>
							<td class="bold">
								Total Amount
							</td>
							<td class="text-left"><?php echo e(number_format($total)); ?></td>
						</tr>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
</body>
</html><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/reports/pdfs/incomes.blade.php ENDPATH**/ ?>