<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style>
		.text-center{
			text-align: center;
		}

		.text-left{
			text-align: left;
		}

		.bold{
			font-weight: bold;
		}

		.heading{
			margin: 20px;
		}
		table{
			border-collapse: collapse;
		}
		thead{
			color: white;
			background: black;
			border-collapse: collapse;
		}
		.item:nth-child(even) {
			background-color: #f2f2f2;
		}
	</style>
</head>
<body>
	<div class="heading">
		<div class="text-center">
			<div class="bold">WYKA CONSULTING GROUP</div>
			<div>Addres: Arua Park Plaza</div>
			<div>Email: finance@wykaconsults.com</div>
			<div>Website: wykaconsults.com</div>
			<div>Tel: +256 784 326279</div>
		</div>
	</div>
	<div class="text-center">
		<div class="bold">Invoices Report</div>
		<div>
			From <?php echo e(date('M d, Y',strtotime($request->start_date)).' To '.date('M d, Y',strtotime($request->end_date))); ?>

		</div>
	</div>
	<div class="heading">
		<table style="width: 100%;">
			<thead>
				<th class="text-left">Invoice No</th>
				<th class="text-left">Customer Name</th>
				<th class="text-center">Issue Date</th>
				<th class="text-center">Amount</th>
				<th class="text-center">Balance</th>
				<th class="text-center">Issued By</th>
			</thead>
			<tbody>
				<?php
				$gross_amount = 0;
				$paid = 0;
				$balance = 0;
				?>
				<?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<?php
				$gross_amount += $invoice->gross_amount;
				$paid += $invoice->paid;
				$balance += $invoice->balance;
				?>
				<tr class="item">
					<td class="text-left"><?php echo e(sprintf("%05d",$invoice->invoice_no)); ?></td>
					<td class="text-left"><?php echo e($invoice->customer->name); ?></td>
					<td class="text-center"><?php echo e(date('M d, Y',strtotime($invoice->issue_date))); ?></td>
					<td class="text-center"><?php echo e(number_format($invoice->gross_amount)); ?></td>
					<td class="text-center"><?php echo e(number_format($invoice->balance)); ?></td>
					<td class="text-center"><?php echo e($invoice->user->name); ?></td>
				</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</tbody>
		</table>
	</div>
	<div class="heading">
		<table width="100%">
			<tr>
				<td width="60%"></td>
				<td>

					<div style="background: #fffafa; border-radius: 7px; padding:10px">
						<table style="width:100%;">
						<tr>
							<td class="bold">
								Total Invoices
							</td>
							<td class="text-left"><?php echo e($invoices->count()); ?></td>
						</tr>
						<tr>
							<td class="bold">
								Amount
							</td>
							<td><?php echo e(number_format($gross_amount)); ?></td>
						</tr>
						<tr>
							<td class="bold">
								Paid
							</td>
							<td><?php echo e(number_format($paid)); ?></td>
						</tr>
						<tr>
							<td class="bold">
								Balance
							</td>
							<td><?php echo e(number_format($balance)); ?></td>
						</tr>
					</table>
					</div>
				</td>
			</tr>
		</table>
	</div>
</body>
</html><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/reports/pdfs/invoices.blade.php ENDPATH**/ ?>