<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Summary;
use App\Models\Expense;
use App\Models\Branch;
use App\Models\Customer;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $metrics = [
            'total_sales' => Summary::sum('total_sales'),
            'total_expenses' => Expense::sum('amount'),
            'current_profit' => Summary::sum('profits_total'),
            'customer_balance' => Customer::sum('balance')
        ];

        // Sales Trend Data (Last 12 Months)
         $salesTrend = Summary::selectRaw('YEAR(date) as year, MONTH(date) as month, SUM(total_sales) as total')
            ->groupBy('year', 'month')
            ->orderBy('year', 'asc')  // Oldest year first
            ->orderBy('month', 'asc') // Oldest month first
            ->limit(12)
            ->get();

        // Branch Performance
        $branchPerformance = Branch::withSum('summaries', 'total_sales')->get();

        return view('dashboard', compact('metrics', 'salesTrend', 'branchPerformance'));
    }
}
