<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Inventory;

class InventoryController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Inventory::class, 'inventory');
	}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $inventories = Inventory::query();

		if (!!$request->trashed) {
			$inventories->withTrashed();
		}

        if(!empty($request->search)) {
			$inventories->where('name', 'like', '%' . $request->search . '%');
		}

        $inventories = $inventories->get();

        return view('inventories.index', compact('inventories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('inventories.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required", "rate" => "required"]);

        try {

            $inventory = new Inventory();
            $inventory->name = $request->name;
		$inventory->rate = $request->rate;
            $inventory->save();

            return redirect()->route('inventories.index', [])->with('success', __('Inventory created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('inventories.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Inventory $inventory
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Inventory $inventory,) {

        return view('inventories.show', compact('inventory'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Inventory $inventory
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Inventory $inventory,) {

        return view('inventories.edit', compact('inventory'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Inventory $inventory,) {

        $request->validate(["name" => "required", "rate" => "required"]);

        try {
            $inventory->name = $request->name;
		$inventory->rate = $request->rate;
            $inventory->save();

            return redirect()->route('inventories.index', [])->with('success', __('Inventory edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('inventories.edit', compact('inventory'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Inventory $inventory
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Inventory $inventory,) {

        try {
            $inventory->delete();

            return redirect()->route('inventories.index', [])->with('success', __('Inventory deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('inventories.index', [])->with('error', 'Cannot delete Inventory: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Inventory $inventory
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $inventory_id,) {

        $inventory = Inventory::withTrashed()->find($inventory_id);
        // $this->authorize('delete', [Inventory::class, $inventory]);

        if (!empty($inventory)) {
            $inventory->restore();
            return redirect()->route('inventories.index', [])->with('success', __('Inventory restored successfully'));
        } else {
            return redirect()->route('inventories.index', [])->with('error', 'Inventory not found');
        }
    }

    public function purge( int $inventory_id,) {

        $inventory = Inventory::withTrashed()->find($inventory_id);
        // $this->authorize('delete', [Inventory::class, $inventory]);

        if (!empty($inventory)) {
            $inventory->forceDelete();
            return redirect()->route('inventories.index', [])->with('success', __('Inventory purged successfully'));
        } else {
            return redirect()->route('inventories.index', [])->with('error', __('Inventory not found'));
        }
    }
    //@endsoftdelete
}
