<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Profit;
use App\Models\Summary;

class ProfitsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $summary = Summary::find($request->summary_id);   
        $profits = Profit::where('summary_id',$summary->id)->get();

        return view('profits.create',compact('summary','profits'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $summary = Summary::find($request->summary_id);

            $total = 0;

            \DB::beginTransaction();


            $profits = Profit::where('summary_id',$summary->id)->delete();

            foreach($request->items as $item){
                if (gettype($item) == "array") 
                {
                    $item = json_encode($item);
                }

                $item = json_decode($item);

                $item->amount = str_replace(",", "", $item->amount);
                $credit = new Profit;
                $credit->summary_id = $summary->id;
                $credit->date = $summary->date;
                $credit->branch_id = $summary->branch_id;
                $credit->amount = $item->amount;
                $credit->created_by_id = \Auth::user()->id;
                $credit->save();

                $total += $credit->amount;
            }

            $summary->profits_total = $total;
            $summary->save();

            \DB::commit();

            return redirect()->back()->with('success','Profits have been saved successfully!');
        }catch(\Throwable $ex){
            return $ex->getMessage()." on line ".$ex->getLine();
            return redirect()->back()->withErrors(['error'=>$ex->getMessage()])->withInput();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
