<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Recovery;
use App\Models\Customer;
use App\Models\Personel;
use App\Models\Summary;

class RecoveriesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $personels = Personel::all();
        $summary = Summary::find($request->summary_id);
        $customers = Customer::all();
        $recoveries = Recovery::where('summary_id',$summary->id)->get();
        // return $recoveries;

        return view('recoveries.create',compact('summary','personels','customers','recoveries'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $summary = Summary::find($request->summary_id);

            $total = 0;

            \DB::beginTransaction();

            $credits = Recovery::where('summary_id',$summary->id)->delete();

            foreach($request->items as $item){
                if (gettype($item) == "array") 
                {
                    $item = json_encode($item);
                }

                $item = json_decode($item);

                $item->amount = str_replace(",", "", $item->amount);
                $credit = new Recovery;
                $credit->summary_id = $summary->id;
                $credit->date = $summary->date;
                $credit->branch_id = $summary->branch_id;
                $credit->customer_id = $item->customer_id;
                $credit->personel_id = $item->personel_id;
                $credit->amount = $item->amount;
                $credit->user_id = \Auth::user()->id;
                $credit->created_by_id = \Auth::user()->id;
                $credit->status = "Pending";
                $credit->save();

                $total += $credit->amount;
            }

            $summary->total_recoveries = $total;
            $summary->save();

            \DB::commit();

            return redirect()->back()->with('success','Recoveries have been saved successfully!');
        }catch(\Throwable $ex){
            \DB::rollback();
            // return $ex->getMessage()." on line ".$ex->getLine();
            return redirect()->back()->withErrors(['error'=>$ex->getMessage()])->withInput();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
